#!/usr/bin/perl
use strict;
use POSIX qw/ strftime /;
use PlatForms;
use Getopt::Long;
use YAML;
use Digest::SHA1 qw/ sha1_hex /;

GetOptions \my %opt, qw/ dictfile=s number|n=i /;
$opt{dictfile} ||= '/usr/share/dict/american-english';
$opt{number}  ||= 1;
my @country_code = qw/
  AD AE AF AG AI AL AM AN AO AQ AR AS AT AU AW AX AZ BA BB BD BE BF BG BH BI BJ
  BM BN BO BR BS BT BV BW BY BZ CA CC CD CF CG CH CI CK CL CM CN CO CR CU CV CX
  CY CZ DE DJ DK DM DO DZ EC EE EG EH ER ES ET FI FJ FK FM FO FR GA GB GD GE GF
  GG GH GI GL GM GN GP GQ GR GS GT GU GW GY HK HM HN HR HT HU ID IE IL IM IN IO
  IQ IR IS IT JE JM JO JP KE KG KH KI KM KN KP KR KW KY KZ LA LB LC LI LK LR LS
  LT LU LV LY MA MC MD ME MG MH MK ML MM MN MO MP MQ MR MS MT MU MV MW MX MY MZ
  NA NC NE NF NG NI NL NO NP NR NU NZ OM PA PE PF PG PH PK PL PM PN PR PS PT PW
  PY QA RE RO RS RU RW SA SB SC SD SE SG SH SI SJ SK SL SM SN SO SR ST SV SY SZ
  TC TD TF TG TH TJ TK TL TM TN TO TR TT TV TW TZ UA UG UM US UY UZ VA VC VE VG
  VI VN VU WF WS YE YT ZA ZM ZW
/;

sub dict_random_it {
  my @word = @_;
  my $n = @word;
  sub {
    $word[int(rand($n))];
  };
}

sub rand_int_it {
  my ($min, $max) = @_;
  $max -= $min - 1;
  sub { int(rand($max)) + $min };
}

my $word_it = do {
  my $file = $opt{dictfile};
  open my $fh, '<', $file or die "Cannot read $file: $!\n";
  my @word;
  while ( <$fh> ) {
    chomp;
    next if tr/a-z//c;
    push @word, $_;
  }
  close $fh;
  dict_random_it(@word);
};
my $country_it = dict_random_it(@country_code);
my $x_it = rand_int_it(-180, 180);
my $y_it = rand_int_it(-90, 90);
my $enneagram_it = rand_int_it(1, 9);

my %code_for = (
  member => sub {
    my $user_it = sub {
      my %user = ();
      $user{firstname} = ucfirst $word_it->();
      $user{lastname} = ucfirst $word_it->();
      $user{username} = lc substr($user{firstname}, 0, 1) . $user{lastname};
      $user{password} = sha1_hex($user{username});
      $user{email} = $user{username} . '@' . $word_it->();
      for ( qw/ motto motto_2 / ) {
        $user{$_} = join ' ', map $word_it->(), 1 .. 4;
      }
      for ( qw/ enneagram_id enneagram_2_id / ) {
        $user{$_} = $enneagram_it->();
      }
      $user{town} = $word_it->();
      $user{gps_x} = my $x = $x_it->();
      $user{gps_y} = my $y = $y_it->();
      $x = $x < 0 ? (-$x) . 'E'
        :            $x  . 'W'
        ;
      $y = $y < 0 ? (-$y) . 'S'
        :            $y  . 'N'
        ;
      $user{gps} = "$x $y";
      $user{country_code} = $country_it->();
      $user{d_registered} = strftime('%Y-%m-%d %H:%M:%S', localtime);
      \%user;
    };
    my $m = PlatForms->model('PbT::Member');
    my @id = $m->insert(map $user_it->(), 1 .. $opt{number});
    print Dump(\@id);
  },
  tests => sub {
    my ($min_id, $max_id) = @_;
    $min_id ||= 1;
    $max_id ||= 100;
    my $member_it = rand_int_it($min_id, $max_id);
    my $rating_it = rand_int_it(-10, 10);

    my $ttt_it = sub {
      my %ttt = ();
      $ttt{member_id} = $member_it->();
      $ttt{d_taken} = strftime('%Y-%m-%d %H:%M:%S', localtime);
      $ttt{mbti} = '';
      for ( qw/ EI SN TF JP / ) {
        $ttt{$_} = $rating_it->();
        my ($from, $to) = split '', $_;
        $ttt{mbti} .= ($ttt{$_} >= 0 ? $from : $to);
      }
      for ( $ttt{mbti} ) {
        /.S.J/ and $ttt{kts} = 'SJ';
        /.S.P/ and $ttt{kts} = 'SP';
        /.NT./ and $ttt{kts} = 'NT';
        /.NF./ and $ttt{kts} = 'NF';
      }
      \%ttt;
    };
    my $mt = PlatForms->model('PbT::TTT');
    my $mm = PlatForms->model('PbT::Member');
    for ( 1 .. $opt{number} ) {
      my $ttt = $ttt_it->();
      my ($id) = $mt->insert($ttt);
      $mm->update($ttt->{member_id}, { active_ttt_id => $id });
    }
  },
  contacts => sub {
    my ($min_id, $max_id) = @_;
    $min_id ||= 1;
    $max_id ||= 100;
    my $member_it = rand_int_it($min_id, $max_id);
    my $contact_it = rand_int_it($min_id, $max_id);
    my $status_it = dict_random_it(qw/ R S I /);
    my $model = PlatForms->model('PbT::Contact_status');
    for ( 1 .. $opt{number} ) {
      my $m = $member_it->();
      my $c = $contact_it->();
      my $s = $status_it->();
      eval {
        $model->insert({member_id => $m, contact_id => $c, status_code => $s});
        $model->insert({member_id => $c, contact_id => $m, status_code => {qw/R S S R I I/}->{$s}});
      };
    }
  },
);

my $action = shift;
$code_for{$action}->(@_);
