package Catalyst::Action::BodyParser;
use strict;

use base qw/ Catalyst::Action /;
use CGI::Expand;
use JSON;

# remove empty keys from a data tree
sub _clean_tree {
  my $tree = shift;

  foreach my $key ( keys %$tree ) {
    if ( UNIVERSAL::isa($tree->{$key}, 'ARRAY') ) {
      foreach ( @{$tree->{key}} ) {
        _clean_tree($_) if UNIVERSAL::isa($_, 'HASH');
      }
    }
    elsif ( UNIVERSAL::isa($tree->{$key}, 'HASH') ) {
      _clean_tree($tree->{$key});
    }
    else {
      delete $tree->{$key} if !(defined($tree->{$key}) && $tree->{$key} ne '');
    }
  }
}

sub execute {
  my $self = shift;
  my ($controller, $c ) = @_;

  my $hash;
  my $body = do {
    my $body_fh = $c->req->body;
    local $/ = undef;
    scalar <$body_fh>;
  };

  my $hash = {};
  if ( !$body ) {
    $hash = expand_cgi($c->req);
  }
  else {
    if ( $c->req->content_type =~ /javascript/i ) {
      $hash = jsonToObj($body);
      _clean_tree $hash;
    }
  }
  $hash->{_body} = $body if $body;
  $self->NEXT::execute(@_, %$hash);
}

1;
