package PlatForms::Controller::Home;

use strict;
use warnings;
use base 'Catalyst::Controller';

=head1 NAME

PlatForms::Controller::Home - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
    my ( $self, $c ) = @_;

    $c->stash->{user} = $c->model('PbT::Member')->fetch($c->session->{member_id});
    $c->stash->{contacts} = [
        map { $c->model('PbT::Member')->fetch($_->{contact_id}, -columns => [qw/ member_id firstname lastname /]) }
        @{
        $c->model('PbT::Contact_status')->select(
        -columns => ["contact_id"],
        -where => {member_id => $c->session->{member_id}},
        );
        }
    ];

    $c->stash->{template} = 'home.tt2';
}


=head1 AUTHOR

Cedric Bouvier,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
