package PlatForms::Controller::Invitation;

use strict;
use warnings;
use base 'Catalyst::Controller';

=head1 NAME

PlatForms::Controller::Invitation - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
    my ( $self, $c ) = @_;

    $c->response->body('Matched PlatForms::Controller::Invitation in Invitation.');
}


sub rcd : Local {
  my ( $self, $c ) = @_;

  my @contacts = $c->request->param('contact_id');
  my $user = $c->session->{current_user};
  my $m = $user->{member_id};

  my $model = "PbT::Contact_status";

  my $transaction = sub {
    my $s = "S";
    foreach my $c (@contacts) {
      $model->insert({member_id => $c, contact_id => $c, status_code => $s});
      $model->insert({member_id => $c, contact_id => $m, 
                      status_code => {qw/R S S R I I/}->{$s}});
    }
  };

  PbT->doTransaction($transaction);
  $c->stash->{n_invitations_sent} = @contacts;
  $c->stash->{template} = "invitation/sent.tt2";
}



=head1 AUTHOR

A clever guy

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
