package PlatForms::Controller::Login;

use strict;
use warnings;
use base 'Catalyst::Controller';

use POSIX;

=head1 NAME

PlatForms::Controller::Login - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut

=head2 index 

=cut

sub index : Private {
  my ( $self, $c, $username, $password ) = @_;

  $username ||= $c->req->param('username');
  $password ||= $c->req->param('password');

  $c->stash->{username} = $username if $username;
  if ( $username && $password ) {
    if ( $c->login($username, $password) ) {
      my $users_ref = PbT::Member->select(-where => {username => $username});
      ($c->session->{current_user}) = @$users_ref
        or die "could not find user $username";

      $c->session->{member_id} = $c->session->{current_user}{member_id};
      my $user_tests = $c->session->{current_user}->tests(-orderBy => 'd_taken DESC');
      $c->session->{ttt_tests} = $user_tests;
                                   
      ($c->session->{active_mbti}) = 
        map {$_->{mbti}} grep {$_->{is_active}} @$user_tests;
        
      $c->res->redirect($c->uri_for('/'));
      return;
    }
    else {
      $c->stash->{error} = 'Invalid username or password';
    }
  } else {
      $c->stash->{error} = 'Password is required' if $username;
  }
  $c->stash->{template} = 'login.tt2';
}

sub logout : Global {
  my ($self, $c) = @_;
  $c->logout;
  $c->model('PbT::Member')->update($c->session->{member_id} => {d_last_logout => POSIX::strftime('%Y-%m-%d %H:%M:%S', localtime)});
  $c->delete_session;
  $c->res->redirect($c->uri_for('/'));
}

=head1 AUTHOR

Cedric Bouvier,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
