package PlatForms::Controller::Members;

use strict;
no warnings;
use base 'Catalyst::Controller';
use Carp;
use Date::Calc qw/Add_Delta_Days Today/;
use Chart::Plot;

=head1 NAME

PlatForms::Controller::Members - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
  my ( $self, $c ) = @_;

  $c->response->body('Matched PlatForms::Controller::Members in Members.');
}

sub form : Local {
  my ( $self, $c ) = @_;
  if ($c->request->param('_submitted')) { # will insert the data in DB
    $self->find_members_from_form($c);
  }
  else {
    $c->stash->{template} = "members/form.tt2";
  }
}

sub graph : Local {
  my ( $self, $c, $axis1, $axis2 ) = @_;
  my $members = $c->session->{member_list};

  $axis1 ||= $c->request->param('axis1');
  $axis2 ||= $c->request->param('axis2');

  $c->log->debug('Axis 1 is ' . $axis1 . ' and axis2 is ' . $axis2);

  #my $full_data = $self->full_member_data_for($members);
  my $full_data = $members;
  $c->log->debug('result sql ' . YAML::Dump($members, $full_data));

  my $img = new Chart::Plot;
  my $colors = ['blue', 'black', 'red', 'green','violet'];
  my @x;
  my @y;
  foreach (@$full_data) {
      push(@x, $_->{$axis1});
      push(@y, $_->{$axis2});
  }
  $img->setData(\@x, \@y, 'violet noline');
  $img->setGraphOptions ('horGraphOffset' => 15,
      'vertGraphOffset' => 15,
      'title' => 'Member List Graph Overview',
      'horAxisLabel' => $axis1,
      'vertAxisLabel' => $axis2,
  );

  $c->res->content_type('image/png');
  $c->res->body($img->draw);
}

sub find_members_from_form {
  my ( $self, $c ) = @_;
  my $params = $c->request->parameters;

  my %criteria; # accumulate criteria to build up the SQL request
  my @nested;

  my $user = $c->session->{current_user}
    or die "didn't find user";

  $criteria{"member.member_id"} = {"!=" => $user->{member_id}};

  my %contact_code_for = ('not_contact' => 'I',
                          'not_rcd'     => 'R');

  if (my $code = $contact_code_for{$params->{"member.contactkind"}}) {
    
    # SQL by hand because too many problems otherwise with binding params 
    # in subquery
    my $subsql = <<"";
SELECT DISTINCT contact_id
       FROM     contact_status 
       WHERE    member_id  = $user->{member_id}
       AND      status_code = '$code'

    $criteria{"member.member_id NOT IN ($subsql)"} = \"";
  }
  
  my %date_checks = (d_registered => "member.registered", 
                     d_taken      => "member.tookTTT" );

  for (my ($db_field, $form_field) = each %date_checks) {
    for ($params->{$form_field}) {
      /^last_logout$/ and do {
        $criteria{$db_field} = {">=" => $user->{d_last_logout}}
          if $user->{d_last_logout};
        last;
      };
      /^\d+$/ and do {
        $criteria{$db_field} = {">=" => date_since($_)};
        last;
      };

      # otherwise
      croak "unexpected value '$_' for '$form_field'" if $_;
    }
  }

  if ($params->{"member.mycountry"}) {
    $criteria{country_code} = $user->{country_code};
  }

  if ($params->{"member.distance"}) {
    my ($x, $y) = @{$user}{qw/gps_x gps_y/};
    if (defined($x) && defined($y)) {
      my $expr = "SQRT(POW(gps_x - $x) + POW(gps_y - $y))";
      $criteria{$expr} = {"<" => $params->{'member.kmsaway'}};
    }
  }

  if ($params->{"member.TTTtypes"}) {
    $criteria{mbti} = {-in => $params->{"member.TTTtypes"}};
  }

  my @enneagrams = grep {$_} @{$user}{qw/enneagram_id enneagram_2_id/};
  if (@enneagrams) {
    for ($params->{"member.Enneagram"}) {
      /same_primary/ and do {
        $criteria{enneagram_id} = $user->{enneagram_id};
        last;
      };

      /one_common/ and do {
        push @nested, [
          enneagram_id   => {-in => \@enneagrams},
          enneagram_2_id => {-in => \@enneagrams},
         ];
        last;
      };

      /one_related/ and do {
        #connectivity     0 1 2 3 4 5 6 7 8 9
        my @en_graph = qw/0 7 4 6 1 8 9 5 2 3/; # see http://www.9types.com/ for theory
        my @related_enneagrams = uniq (@enneagrams, map {$en_graph[$_]} @enneagrams);
        push @nested, [
          enneagram_id   => {-in => \@related_enneagrams},
          enneagram_2_id => {-in => \@related_enneagrams},
         ];
        last;
      };
    }
  }

  if (my $motto_req = $params->{"member.mottocontains"}) {
    $criteria{"MATCH(motto, motto2) AGAINST"} = $motto_req;
  }
  



  $criteria{-nest} = [-and => \@nested ] if @nested;

=begin BUGGY

  # BUGGY --- COULDN'T FIND OUT WHY
  #my $view = PbT->ViewFromRoles(qw/PbT::Member active_ttt/);
  # $criteria{is_active} = 1;
  # my $view = PbT->ViewFromRoles(qw/PbT::Member => tests/);

  

  my $member_list  = $view->select(-distinct => '*',
               -where    => \%criteria,
               -postSQL  => sub {my ($sql, @bind) = @_; # fixing syntax for MySQL
                                 $sql =~ s/AGAINST = \?/AGAINST (?)/g;

                                 # FOR DEBUGGING
                                 $c->stash->{sql} = $sql;

                                 return ($sql, @bind);},
              );

   OK , NO TIME TO FIX, LET'S TAKE BRUTE FORCE
=end BUGGY

=cut

  $criteria{is_active} = 1;
  my $member_list = PbT::Member->select(
    -distinct => '*',
    -where    => \%criteria,
    -postSQL  => sub {
      my ($sql, @bind) = @_; 
      $sql =~ s/AGAINST = \?/AGAINST (?)/g;
      $sql =~ s[FROM *member]
               [FROM member LEFT OUTER JOIN ttt ON member.member_id=ttt.member_id]i;
      # FOR DEBUGGING
      $c->stash->{sql} = $sql;
      
      return ($sql, @bind);
    },
   );

  $c->session->{member_list} = $member_list;
  $c->stash->{template} = "members/list.tt2";
}


#----------------------------------------------------------------------
# utility functions
#----------------------------------------------------------------------

=begin usage

   my $full_data = $self->full_member_data_for($c->session->{member_list});

=end usage

=cut 

sub full_member_data_for {
  my ( $self, $list_ref ) = @_;

  return PbT->ViewFromRoles(qw/PbT::Member tests/)
      ->select(-where    => {"member.member_id" => {-in => $list_ref},
                             is_active => 1});
}





sub date_since {
  my $delta = shift;
  my @date = Add_Delta_Days(Today, -$delta);
  return sprintf "%4d-%2d-%2d 00:00:00", @date;
}


1;
