package PlatForms::Controller::Register;

use strict;
use warnings;
no warnings 'uninitialized';
use base 'Catalyst::Controller';

use Digest::SHA1 qw/ sha1_hex /;
use POSIX;
use JSON;

=head1 NAME

PlatForms::Controller::Register - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut

=head2 index 

=cut

sub index : Private {
    my ( $self, $c ) = @_;
    
    my $countries = $c->model('PbT::Country')->select( 
        -orderBy => "name",
    );
    $c->stash->{countries} = $countries;
    $c->stash->{user} = objToJson($c->session->{current_user}) if $c->session->{current_user};

    $c->stash->{template} = 'register.tt2';
}

sub _clean_likes {
  my ($self, $c, $likes, $affinity) = @_;

  my @out_likes;
  foreach my $like ( @$likes ) {
    next unless $like->{interest_id} || $like->{name};
    if ( !$like->{interest_id} ) {
      $like->{interest_id} = $c->model('PbT::Interest')->insert({name => delete $like->{name}});
    }
    $like->{affinity} = $affinity;
    push @out_likes;
  }
  return @out_likes;
}

sub save : Local : ActionClass('BodyParser') {
  my ($self, $c, %param) = @_;

  my $member_id;
  my $clear_password;
  my $candidate;
  eval {
    $candidate = $param{user};
    foreach my $key ( keys %$candidate ) {
      delete $candidate->{$key} unless $candidate->{$key};
    }
    if ( $candidate->{password} ne $candidate->{conf_password} ) {
      die "password and confirmation mismatch\n";
    }
    my @missing;
    for ( qw/ lastname email username password motto town country_code / ) {
      push @missing, $_ unless $candidate->{$_};
    }
    die "Missing field(s): " . join(', ' => @missing) . "\n" if @missing;
    $clear_password = delete $candidate->{conf_password};
    $candidate->{password} = lc sha1_hex $candidate->{password};
    $candidate->{d_registered} = POSIX::strftime('%Y-%m-%d %H:%M:%S', localtime);
    my @likes = (
      $self->_clean_likes($c, delete($candidate->{dislike}), 'D'),
      $self->_clean_likes($c, delete($candidate->{like}),    'L'),
    );
    if ( my $gps = $candidate->{gps} ) {
      my ($x, $ns, $y, $ew) = $gps =~ /
        (\d(?:\.\d+)?)  # latitute
        \s*
        ([NnSs])        # north or south
        \s*
        ,?
        \s*
        (\d(?:\.\d+)?)  # longitude
        \s*
        ([EeWw])        # east or west
      /x
        or die qq{Invalid GPS coordinates (should be e.g. "1.23 N 3.45 E")\n};
      $x = -$x if uc $ns eq 'S';
      $y = -$y if uc $ew eq 'E';
      $candidate->{gps_x} = $x;
      $candidate->{gps_y} = $y;
    }

    if ( $candidate->{member_id} ) {
      # update
      $member_id = $candidate->{member_id};
      $c->model('PbT::Member')->update($member_id => $candidate);
      # FIXME modification of likes and dislikes :-(
    }
    else {
      # insert
      ($member_id) = $c->model('PbT::Member')->insert($candidate);
      my $new_user = $c->model('PbT::Member')->fetch($member_id);
      $new_user->insert_into_member_interests(@likes) if @likes;
    }
  };
  if ( $@ ) {
    $c->stash->{object}{status} = 0;
    $c->stash->{object}{errors} = { form => $@ };
  }
  else {
    $c->login($candidate->{username}, $clear_password);
    $c->stash->{object} = {
      status => 1,
      redirect_to => $c->uri_for('/')->as_string,
    };
  }
  $c->log->debug(YAML::Dump($c->stash->{object}));
  $c->res->content_type('text/javascript');
  $c->res->body(objToJson($c->stash->{object}));
  $c->log->debug($c->res->body);
  return 1;
}

sub checkUsername: Local {
  my ($self, $c, $username) = @_;
  $username = $c->req->param('username') || $username
    or die "Username missing";

  my $entry = $c->model('PbT::Member')->select(-where => {username => $username});
  $c->res->content_type('text/javascript; charset=ISO-8859-1');
  $c->res->header('Cache-Control' => 'no-cache, must-revalidate, max-age=0');
  if ($entry) {
      if (@$entry) {
          $c->res->body("0");
      } else {
          $c->res->body("1");
      }
  }
}

=head1 AUTHOR

Cedric Bouvier,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
