package PlatForms::Controller::Root;

use strict;
use warnings;
use base 'Catalyst::Controller';

#
# Sets the actions in this controller to be registered with no prefix
# so they function identically to actions created in MyApp.pm
#
__PACKAGE__->config->{namespace} = '';

=head1 NAME

PlatForms::Controller::Root - Root Controller for PlatForms

=head1 DESCRIPTION

[enter your description here]

=head1 METHODS

=cut

=head2 default

=cut

sub default : Private {
    my ( $self, $c ) = @_;

    # Hello World
    $c->forward('/home/index');
}

sub auto : Private {

  my ($self, $c) = @_;

  if ( $c->config->{base} ) {
    my $base = bless( do { \( my $o = $c->config->{base} ) }, 'URI::http' );
    $c->req->base($base);
  }

  return 1 if
       $c->controller eq $c->controller('Style')
    || $c->controller eq $c->controller('SOAP')
    || $c->controller eq $c->controller('Login')
    || $c->controller eq $c->controller('Register')
  ;

  if ( !$c->user_exists ) {
      $c->res->redirect($c->uri_for('/login'));
      return 0;
  }
  return 1;
}

sub not_implemented : Local {
  my ( $self, $c ) = @_;
  $c->stash->{template} = "not_implemented.tt2";
}

sub sample_graph : Local {
  my ( $self, $c ) = @_;

  my @set;
  my( $data );

  for(my $t=0; $t<200; $t++){
    my $v = sin( $t/40 ) ;
    my $z = abs( sin( $t/8 )) / 2;
    push @$data, {
      time  => $^T + $t  * 5000,
      value => $v,
      min   => $v - $z,
      max   => $v + $z,
    };
  }

  push(@set, { data => $data, opts => { label => 'Drakh',
        style => 'range',
        color => '00FF00'} });

  push(@set, { data => $data, opts => { style => 'line',
        color => '0000FF'} });

  $data = [];
  for(my $t=10; $t<210; $t++){
    my $v = (.07,0,0,-.15,1,0,-.3,0,0,0,.07,.07)[$t % 25] || 0;

    push @$data, {
      time  => $^T + $t  * 5000,
      value => ($v + $t / 100 - 1.5),
    };
  }

  push(@set,{ data=> $data, opts => { label => 'Scarran',
        color => 'FF0000'} });

  $data = [];
  for(my $t=10; $t<210; $t+=15){

    push @$data, {
      time  => $^T + $t  * 5000,
      value => sin( $t/30 + 1 ) - .2,
      diam  => abs(20*sin($t/55 - 1)) + 3,
    };
  }

  push(@set, { data => $data, opts => { label => "G'ould",
        style => 'points',
        color => '0000FF'} });

  $c->stash->{chart_opts}->{title} =
  'Alient Experimentation on the Population of New England';
  $c->stash->{chart_data} = \@set;

  $c->forward('View::Chart');
}

=head2 end

Attempt to render a view, if needed.

=cut 

sub end : ActionClass('RenderView') {}

=head1 AUTHOR

Cedric Bouvier,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
