package PlatForms::Controller::SOAP;

use strict;
use warnings;
use base 'Catalyst::Controller';

use SOAP::Transport::HTTP;

=head1 NAME

PlatForms::Controller::SOAP - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
  my $self = shift;
  my $c = shift;

    $c->forward('soap', [ @_ ]);
}

sub soap : Local : ActionClass('BodyParser') {
  my ($self, $c, %param) = @_;

  my $som = SOAP::Deserializer->deserialize($param{_body});
  
  my $method = (keys %{$som->body})[0];

  $c->res->body(YAML::Dump($method, $som->method));
  $c->res->content_type('text/xml');
  $c->res->body(
    SOAP::Serializer
    ->envelope(
      response => 'loginResult',
      SOAP::Data->new(name => 'loginReturn', value => 'blahblah')
    )
  );
  $c->log->debug($c->res->body);
}

=head1 AUTHOR

Cedric Bouvier,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
