package PlatForms::Controller::TemperamentTest;

use strict;
use warnings;
use base 'Catalyst::Controller';
use Carp;

=head1 NAME

PlatForms::Controller::TemperamentTest - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut


my @ttt_dimensions = qw/I E S N T F J P/; # pairs, preferred label first
my @dimension_pairs = qw/EI SN TF JP/;


sub index : Private {
    my ( $self, $c ) = @_;

    $c->response->body('Matched PlatForms::Controller::TemperamentTest in TemperamentTest.');
}


my $cached_questions;

sub form : Local {
  my ( $self, $c ) = @_;
  if ($c->request->param('_submitted')) { # will insert the data in DB
    my $personality = $self->compute_form_result($c);
    if (!$personality) {
      $c->stash->{template} = "temperamenttest/rejected.tt2";
    }
    else {
      $c->stash->{personality} = $personality;

      my @numbers = ($personality->{long_profile} =~ /(\d+)/g);

      my $user = $c->session->{current_user};

      my %record = (mbti => $personality->{mbti},
                    kts  => $personality->{kts});

      $record{$_} = $personality->{$_} foreach @dimension_pairs;
      my $ttt_id= $user->insert_into_tests(\%record);
      $self->upd_active_ttt($c, $user, $ttt_id, $record{mbti});
      $c->session->{ttt_tests} = $user->tests(-orderBy => 'd_taken DESC');

      $c->stash->{template} = "temperamenttest/result.tt2";
    }
  }
  else {
    $c->stash->{questions} = $cached_questions 
                         ||= $self->load_questions($c);
    $c->stash->{template} = "temperamenttest/form.tt2";
  }
}



sub list : Local {
  my ( $self, $c ) = @_;

  my $user = $c->session->{current_user};
  $c->stash->{active_ttt_id} = $user->{active_ttt_id};
  $c->stash->{template} = "temperamenttest/list.tt2";
}

sub set_active_ttt_test : Local {
  my ( $self, $c ) = @_;
  my $ttt_id = $c->request->param("ttt_id");
  if ($ttt_id) {
    my $ttt = PbT::TTT->fetch($ttt_id) || {};
    $self->upd_active_ttt($c, $c->session->{current_user}, $ttt_id, $ttt->{mbti});
  }
  $c->forward('/home/index');
}

#----------------------------------------------------------------------
# internal methods
#----------------------------------------------------------------------




sub upd_active_ttt : Local {
  my ( $self, $c, $user, $ttt_id, $mbti) = @_;
  my $transaction = sub {
    my $old_actives = $user->tests(-where => {is_active => 1});

    # not efficient, but no more time to get it right
    foreach my $old (@$old_actives) {
      PbT::TTT->update({ttt_id => $old->{ttt_id}, is_active => 0});
    }
    PbT::TTT->update({ttt_id => $ttt_id, is_active => 1});
  };
  PbT->doTransaction($transaction);
  $c->session->{active_mbti} = $mbti;
  return $ttt_id;
}



sub compute_form_result {
  my ( $self, $c ) = @_;

  my %dim_count;

  $cached_questions ||= $self->load_questions($c);

  foreach my $index (0 .. (@$cached_questions - 1)) {
    no warnings 'uninitialized';
    if (my $dim = $c->request->param("Q.$index.answer")) {
      $dim_count{$dim} += 1;
    }
  }

  return $self->compute_profile (\%dim_count);
}



sub compute_profile {
  my ($self, $counts) = @_;

  my $personality = {};

  my %dim_count;
  $dim_count{$_} = 0 foreach @ttt_dimensions;


  foreach my $pair (@dimension_pairs) {
    my ($letter1, $letter2) = split //, $pair;

    no warnings 'uninitialized'; 

    my $n_answers = $counts->{$letter1} + $counts->{$letter2};
    return undef if $n_answers < 5; # not enough answers, see req S36

    my $delta =  $counts->{$letter1} - $counts->{$letter2};
    $personality->{$pair} = $delta;
    my ($letter, $num) = $delta >= 0 ? ($letter1, $delta) 
                                     : ($letter2, -$delta);
    $letter = "I" if $letter eq "E" && $delta == 0; # exception
    $personality->{long_profile}  .= "$letter+$num";
    $personality->{mbti}          .= $letter;
  }

  my $kts_types = {
    SJ => {regex => qr/.S.J/, name => "Guardian"},
    SP => {regex => qr/.S.P/, name => "Artisan"},
    NT => {regex => qr/.NT./, name => "Rational"},
    NF => {regex => qr/.NF./, name => "Idealist"},
   };

  my $kts;
  while (my ($k, $details) = each %$kts_types) {
    if ($personality->{mbti} =~ $details->{regex}) {
      $personality->{kts} = $k;
      $personality->{kts_name} = $details->{name};
      last;
    }
  }

  $personality->{kts} 
    or croak "no kts type for MBTI $personality->{mbti}";

  return $personality;
}


sub load_questions  {
  my ( $self, $c ) = @_;

  my $filename = $c->config->{questions_file} or
    croak 'No "questions_file" in config';

  $filename = Catalyst::Utils::home('PlatForms') . '/' . $filename 
    unless $filename =~ m!^/!;


  open my $fh, $filename or croak $!;

  my $questions = [];
  my $index = 0;

  while (my $ask = <$fh>) {
    my $answer1 = <$fh>;
    my $answer2 = <$fh>;
    my $void    = <$fh>;
    chomp for ($ask, $answer1, $answer2);

    my ($dim1, $dim2);
    $answer1 =~ s/(.):// and $dim1 = $1 or croak "invalid question";
    $answer2 =~ s/(.):// and $dim2 = $1 or croak "invalid question";
    push @$questions, {ask     => $ask, 
                       dim1    => $dim1,
                       answer1 => $answer1,
                       dim2    => $dim2,
                       answer2 => $answer2,
                       index   => $index++};
  }
  return $questions;
}



=head1 AUTHOR

A clever guy

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
