package PlatForms::Model::PbT;

use strict;
use warnings;
use base 'Catalyst::Model';
use DBIx::DataModel;


=head1 NAME

PlatForms::Model::PbT - Catalyst Model

=head1 DESCRIPTION

Catalyst Model.

=head1 AUTHOR

A clever guy

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut



BEGIN {

DBIx::DataModel->Schema('PbT');

PbT->Table(qw/PbT::Member             member          member_id/);
PbT->Table(qw/PbT::TTT                ttt             ttt_id/);
PbT->Table(qw/PbT::Login              login           login_id/);
PbT->Table(qw/PbT::Interest           interest        interest_id/);
PbT->Table(qw/PbT::Contact_status     contact_status  member_id contact_id/);
PbT->Table(qw/PbT::Search             search          search_id/);
PbT->Table(qw/PbT::Member_interest    member_interest member_interest_id/);
PbT->Table(qw/PbT::Status             status          status_code/);
PbT->Table(qw/PbT::Country            country         country_code/);


PbT->Composition([qw/PbT::Member           member           1/],
                 [qw/PbT::TTT              tests            */]);

PbT->Composition([qw/PbT::Member           member           1/],
                 [qw/PbT::Member_interest  member_interests */]);

PbT->Association([qw/PbT::Interest         interest         1/],
                 [qw/PbT::Member_interest  member_interests */]);

PbT->Composition([qw/PbT::Member           member           1/],
                 [qw/PbT::Search           searches         */]);

PbT->Composition([qw/PbT::Member           member           1/],
                 [qw/PbT::Login            logins           1..*/]);

PbT->Association([qw/PbT::Member           member           1 member_id/],
                 [qw/PbT::Contact_status   contacts_status_as_member
                                                            * member_id/]);

PbT->Association([qw/PbT::Member           contact          1 member_id/],
                 [qw/PbT::Contact_status   contacts_status_as_contact
                                                            * contact_id/]);

PbT->Association([qw/PbT::Member  members  * contacts_status_as_contact 
                                               member/],
                 [qw/PbT::Member  contacts * contacts_status_as_member
                                               contact/]);

PbT->Composition([qw/PbT::Status           status           1/],
                 [qw/PbT::Contact_status   contact_status   1..*/]);

PbT->Association([qw/PbT::Country          country          1/],
                 [qw/PbT::Member           members          1..*/]);


# PbT->Association([qw/PbT::Member           none          1    active_ttt_id /],
#                  [qw/PbT::TTT              active_ttt    0..1 ttt_id        /]);


}



use NEXT;
use DBI;

sub new {
  my $self = shift->NEXT::new(@_);

  my $class = ref($self);
  (my $class_prefix = $class) =~ s/::PbT$//;
  my $dbh = DBI->connect_cached($self->{dsn}, $self->{username}, $self->{password}, {RaiseError => 1})
    or die $DBI::errstr;
  PbT->dbh($dbh);

  no strict 'refs';
  foreach my $table_class ( PbT->tables ) {
    my $classname = $class_prefix . "::$table_class";
    *{$classname . '::ACCEPT_CONTEXT'} = sub {
      my ( $self, $c ) = @_;
      return $table_class;
    };
  }
  *{$class . '::ACCEPT_CONTEXT'} = sub {
    return 'PbT';
  };
  return $self;
}


1;
