package PlatForms::View::CSS;

use strict;
use base 'Catalyst::View::TT';

__PACKAGE__->config({
    CATALYST_VAR => 'Catalyst',
    INCLUDE_PATH => [
        PlatForms->path_to( 'root', 'style' ),
    ],
    TIMER        => 0,
    TEMPLATE_EXTENSION => '.css',
});

sub process {
  my $self = shift;
  my $c    = shift;

  $c->response->content_type('text/css');
  $c->response->headers->expires(time + $self->{expire_after});
  $self->SUPER::process($c, @_);
}

=head1 NAME

PlatForms::View::CSS - Catalyst TT View

=head1 SYNOPSIS

See L<PlatForms>

=head1 DESCRIPTION

Catalyst TT View.

=head1 AUTHOR

A clever guy

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;

