package PWx::Exception;

use warnings;
use strict;

use version; our $VERSION = qv("0.3.0");

use Exception::Class (
       'PWx::Exception' => { description => 'generic base class for all PGP exceptions' },
       'PWx::Exception::AP' => {
                                 description => 'Application Exception',
                                 isa         => 'PWx::Exception',
                                 alias       => 'throw_ap',
                               },
       'PWx::Exception::TTT' => {
                                 description => 'TTT Questions unclomplete',
                                 isa         => 'PWx::Exception',
                                 alias       => 'throw_ttt',
                               },
                     );

use Log::Log4perl qw (get_logger);

sub log {
    my $self   = shift;
    my $logger = get_logger('PWx::Exception');
    $logger->error("LOG ", $self->description, "\n", $self->error);
}

1;    # End of code PWx::Exceptions

__END__

=head1 NAME

PWx::Exceptions - Dokumentation zu PWx::Exceptions!

=head1 VERSION

$Id$

=head1 SYNOPSIS


=head1 METHODS

=head2 log

 log() Logs Exception via Log4perl and category PWx::Exception

=head1 AUTHOR

Rolf Schaufelberger, C<< <rs@plusw.de> >>

=head1 COPYRIGHT & LICENSE

Copyright 2006-2007 plusW, Rolf Schaufelberger.  All Rights Reserved.

As this program is no free software, you are not allowed to redistribute
and/or sell it, not even to modify or copy it.

