#==================================================
# $Id$
#==================================================

#==================================================
# Editieren von Attributen -> nur Admin
#==================================================
package PWx::EditControlRule;
use base qw[Apache::SiteControl::Rule];
use version; our $VERSION = qv('0.1.1');

sub grants($$$$) {
    my ($this, $user, $action, $resource) = @_;
    return 0 unless $action eq 'admin';
    return 1
      if ($user->company_id()->id() eq '1' || $user->company_id()->id() eq '2');
    return 0;
}

sub denies($$$$) {
    return 0;
}

#==================================================
# Menu_prod
#==================================================
package PWx::ProductRule;
use base qw[Apache::SiteControl::Rule];
use version;
our $VERSION = qv('0.1.0');

sub grants {
    my ($this, $user, $action, $resource) = @_;

    return 0
      unless $action
      && (   $action eq 'single'
          || $action eq 'liste');

    # No fuer Guest
    return 0 if ($user->company_id eq '4');

    # Yes for Admin
    return 1 if ($user->company_id eq '1');
}

sub denies($$$$) {
    return 0;
}

#==================================================
# Rollen aus DB
#==================================================
package PWx::AuthRoleRule;
use base qw[Apache::SiteControl::Rule];
use version;
our $VERSION = qv('0.1.0');

# prueft, ob es einen Eintrag in Permissions gibt, der
# action, resource fuer den User entspricht

sub grants {
    my ($this, $user, $action, $resource) = @_;

    my $perm =
      $user->roles->search_related(
                                   'permissions',
                                   {
                                      resource => $resource,
                                      action   => $action
                                   }
                                  )->single;

    return $perm ? 1 : 0;
}

sub denies($$$$) {
    return 0;
}

#==================================================
package PWx::PermissionManager;

use warnings;
use strict;

use version;
our $VERSION = qv('0.7.1');

use Apache::SiteControl::PermissionManager;
use Apache::SiteControl::GrantAllRule;

use base qw[Apache::SiteControl::ManagerFactory];
our $manager;

sub getPermissionManager {
    return $manager if defined($manager);

    $manager = new Apache::SiteControl::PermissionManager;

    #$manager->addRule(new Apache::SiteControl::GrantAllRule);
#    $manager->addRule(new PWx::EditControlRule);
#    $manager->addRule(new PWx::ProductRule);
    $manager->addRule(new PWx::AuthRoleRule) or die $!;

    return $manager;
}

1;
__END__

=head1 NAME

PWx::PermissionManager - The great new PWx::PermissionManager!

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';

=head1 SYNOPSIS

Quick summary of what the module does.

Perhaps a little code snippet.

    use PWx::PermissionManager;

    my $foo = PW::PermissionManager->new();
    ...


=head1 RULES

Folgende regelen sind implementiert:

=head2 AuthRoleRule 

Regeln basieren auf den DB Tabellen   permissions, auth_roles, role_assignments
d.h es wird in der Db abgefragt, ob esd einen Eintrag fuer die resource und die Action fuer diesen user gibt.

Diese Regeln werden dafuer verwendet umd im Adminbereich zu steuern, wer was darf.

=head2 ProductRule

ist zum Steuern des menues gedacht und liefert derzeit eine 0 fuer gast und eine 1 fuer company_id 1, 
was nicht so arg viel Sinn ergibt....


=head2 EditControlRule

Prueft derzeit nur Admin Rechte, d.h. lifert 1 wenn action=admin und die Company_id i (1,2) ist.

=head1 AUTHOR

Rolf Schaufelberger, C<< <rs@plusw.de> >>

=head1 ACKNOWLEDGEMENTS

=head1 COPYRIGHT & LICENSE

Copyright 2003-2006 plusW, Rolf Schaufelberger, All Rights Reserved.

As this program is no free software, you are not allowed to redistribute and/or
sell it, not even to modify or copy it.

=cut

1; # End of PW::PermissionManager
