package PWx::SOAP::App;

use Apache;
use Apache::Constants qw(OK FORBIDDEN);
use PWx::Application;

use SOAP::Lite;
import SOAP::Data 'name';

# needed to get envelope on method calls
our @ISA = qw(SOAP::Server::Parameters);

use constant DEBUG => 1;
use PWx::Exceptions;

sub _init {
  my $a = PWx::Application->instance('PWx::Site::Platf');
  my $s = $a->schema;
  return $s;
}

sub login {
  my $pkg = shift;
  my $env = pop;
  my $args = $env->method || {};
  my $username = $args->{username};
  my $password = $args->{password};
  
  return name(result=>undef) unless ($username =~ /\w+/ && $password =~ /\w+/ );

#  my $s= _init();

  return name(result => '_sess_' .$username);
}

sub logout {
  my $pkg = shift;
  my $env = pop;
  my $args = $env->method || {};

  return name(result=>'Logged out') ;
}

sub clearDatabase {
  my $pkg = shift;
  my $env = pop;
  my $args = $env->method || {};
  my $s= _init();
  $s->resultset('Rcds')->delete_all();
  $s->resultset('Results')->delete_all();
  $s->resultset('Users')->delete_all();

  $s->txn_commit;

  return undef ;
}

sub submitMemberinfo {
  my $pkg = shift;
  my $env = pop;
  my $args = $env->method || {};

  return undef ;
}

sub getMemberinfo {
  my $pkg = shift;
  my $env = pop;
  my $args = $env->method || {};

  return undef ;
}



sub takeTtt {
  my $pkg = shift;
  my $env = pop;
  my $args = $env->method || {};

  return undef ;
}

sub searchForMembers {
  my $pkg = shift;
  my $env = pop;
  my $args = $env->method || {};

  return undef ;
}

sub searchForMembersGraphic {
  my $pkg = shift;
  my $env = pop;
  my $args = $env->method || {};

  return undef ;
}

sub  getMemberlist {
  my $pkg = shift;
  my $env = pop;
  my $args = $env->method || {};

  return undef ;
}

sub  getMemberlistGraphic {
  my $pkg = shift;
  my $env = pop;
  my $args = $env->method || {};

  return undef ;
}

sub sendRcd {
  my $pkg = shift;
  my $env = pop;
  my $args = $env->method || {};

  return undef ;
}


1;
