package PWx::Site::Platf::DB::Users;

use strict;
use warnings;
use version; our $VERSION = qv('0.1.0');
use base qw [DBIx::Class];
__PACKAGE__->load_components(qw/Core PK::Auto/);

__PACKAGE__->table('users');
__PACKAGE__->sequence('users_id_seq');
__PACKAGE__->add_columns(
    qw(id register_date firstname lastname username password email city country_id life_motto life_motto2 likes dislikes gps enneagram1_type_id enneagram2_type_id result_id last_logout)
);
__PACKAGE__->set_primary_key('id');
__PACKAGE__->belongs_to(result  => 'PWx::Site::Platf::DB::Results',   'result_id');
__PACKAGE__->belongs_to(country => 'PWx::Site::Platf::DB::Countries', 'country_id');
__PACKAGE__->belongs_to(enneagram1_type => 'PWx::Site::Platf::DB::EnneagramTypes',
                        'enneagram1_type_id');
__PACKAGE__->belongs_to(enneagram2_type => 'PWx::Site::Platf::DB::EnneagramTypes',
                        'enneagram2_type_id');
__PACKAGE__->has_many(rcds => 'PWx::Site::Platf::DB::Rcds', 'f_user_id');
1;
