package PWx::Site::Platf::Handler;

use warnings;

use strict;
use version; our $VERSION = qv('0.3.0');

use Apache::Constants qw( OK REDIRECT SERVER_ERROR );

use UNIVERSAL::require;

use PWx::I18N;
use PWx::Site::Platf::WebApp;
use PWx::Site::Platf::I18N;
use PWx::Site::Platf::DB;

my $ah =
  MasonX::WebApp::ApacheHandler->new(
    args_method => 'mod_perl',
    comp_root   =>
      [[lib => '/serv/www/platf.plusw.de/lib'], [pgp => '/serv/www/platf.plusw.de/data']],
    data_dir      => '/serv/www/platf.plusw.de/mason/',
    allow_globals => [qw ($App )],
    error_mode    => 'fatal',
    decline_dirs  => 0,
    static_source => 1,
  );

my $base = 'PWx::Site::Platf';
my $i18n = init_i18n($base);

sub handler ($$) {
    my $class = shift;
    my $r     = shift;

    # Handling directory requests (ending with /)
    if (   $r->content_type eq 'httpd/unix-directory'
        && $r->uri =~ '/$'
        && $r->is_initial_req)
    {

        # print STDERR "Accepting Directory Request\n";
        $r->internal_redirect($r->uri . 'index.html');
        return OK;
    }

    my $apr  = Apache::Request->new($r);
    my $args = $ah->request_args($apr);

    my $app ;
    my $return;

    eval {
      $app =
      PWx::Site::Platf::WebApp->new(
                                    apache_req => $apr,
                                    args       => $args,
                                    i18n       => $i18n,
                                    base       => $base,
                                   );

      return REDIRECT if $app->redirected;
      return if $app->aborted;

      local $HTML::Mason::Commands::App = $app;

      $return =  $ah->handle_request($apr);
      $app->clean_session;
    };

    my $err = $@;

    if ($err) {
        $r->pnotes('error' => $err);
        $r->filename($r->document_root . '/error/500.html');
        local $HTML::Mason::Commands::App = $app;
        $return = $ah->handle_request($r);
    }

    # We want to wipe out the variable before the request ends,
    # because if the $ah variable persists, then so does the interp,
    # which means the $app object won't be destroyed until the next
    # request in this process, which can hose up sessions big time.
    $ah->interp->set_global('$App' => undef);

    return $return;
}

sub init_i18n {
    my $base = shift;
    my $i18n;

    eval {

        # Die ParameterKlasse
        my $paramClass = $base . '::Param';
        $paramClass->require;
        my $param = $paramClass->new();

        #die DB Classe
        my $dbClass = $base . '::DB';
        $dbClass->require;
        my $schema = PWx::DB->connect;

        #die Locale Klasse
        my $i18nClass = $base . '::I18N';
        $i18nClass->require;

        $i18n =
          $i18nClass->create(
                             schema    => $schema,
                             languages => [keys %{ $param->Languages() }],
                             app       => $param->LexiconKey
                            );
    };
    return $i18n;
}

{

    package HTML::Mason::Commands;

    use Encode;

#    use Fcntl;
    use IO::File;
    use MLDBM;          # * Starred mods are available on CPAN
    use URI::Escape;    # *

    use File::Spec::Functions;
    use HTML::FillInForm;

    use Log::Log4perl;
    use DBIx::Class;

    use PWx::Exceptions;

#    use PWx::User;
#    use PWx::User::Guest;
}

1;

__END__

=head1 NAME

PWx::Site::Dtasp::Handler - Handler fuer Dtasp-Site!

=head1 VERSION

$Id: Handler.pm 938 2006-10-09 09:12:11Z rs $

=head1 AUTHOR

Matthias Dietrich, C<< <md@plusw.de> >>

=head1 COPYRIGHT & LICENSE

Copyright 2006 plusW, Rolf Schaufelberger.  All Rights Reserved.

As this program is no free software, you are not allowed to redistribute
and/or sell it, not even to modify or copy it.

=cut


