package PWx::Site::Platf::WebApp;
use PWx::TTT;

=pod

=head1 TTT_Start

Initialises the session

=cut

sub TTT_Start {
    my $self = shift;

    my $page = 1;

    delete ($self->session->{ttt});
    $self->session->{_force_write_} =1;

    $self->_save_arg(page=>$page);
    $self->redirect( uri => '/ttt/index.html');
}

=pod

=head1 TTT_Page

=cut

sub TTT_Page {
    my $self = shift;

    my $page  = $self->args->{page} || 0;
    my $forw  = $self->args->{forward};
    my $back  = $self->args->{back};
    my $store = $self->args->{store};

    # Store result in session
    my @answers = grep (/A\.\d+/ , keys %{$self->args} );
    foreach (@answers ) {
      $self->session->{ttt}{answers}{$_} = $self->args->{$_};
    }		
    if ( $forw ) {
       $page++ ;
     } else {
       $page--;
     }

    if ( $page > 4 || $store ) {
      # check and Store values 
      my $ttt = PWx::TTT->new(answers => $self->session->{ttt}{answers},
			      user_id => $self->current_user->id );
#       unless ($ttt->checkRequirements (); ) {
# 	 $self->_handle_error(
# 			      error => 'TTT.MinQuestions',
# 			      path  => '/ttt/index.html',
# 			     );
#        }
      $ttt->saveResult();

      $self->_save_arg(result=> $ttt->{result} );
      $self->redirect( uri =>'/ttt/status.html');
    } else {
      $self->_save_arg(page=>$page);
      $self->redirect( uri => '/ttt/index.html');
    }
}

1;

