package PWx::TTT::Result;

use warnings;
use strict;

=head1 NAME

PWx::TTTResult - Represent a TTT full result.

=head1 VERSION

Version 0.1.0

=cut

our $VERSION = '0.1.0';

=head1 SYNOPSIS

Use this to work with a ttt result.

    use PWx::TTTResult;

    my $res = PWx::TTTResult->new('E+4S+5T+1J+0');

=head1 FUNCTIONS

=head2 new

Constructs a new ttt result object. This expects the stringified 
result as a paremter

=cut

sub new {
	my($class, $rstring) = (shift, shift);
	my $self = {rstring => $rstring};
	bless $self, $class;
	$self->parse;
	return $self;
}

=head2 parse

Reads the stringified result and extracts all needet informations.

=cut

sub parse {
	my $self = shift;
	
	$self->{rstring} =~ /^(E|I)\+(\d+)(S|N)\+(\d+)(T|F)\+(\d+)(J|P)\+(\d+)$/;
	
	$self->{ei} = [$1, $2];
	$self->{sn} = [$3, $4];
	$self->{tf} = [$5, $6];
	$self->{jp} = [$7, $8];
	
	do {
		$self->{primary} = $_ if !defined $self->{primary} || $self->{$_}->[1] > $self->{$self->{primary}}->[1];
	} foreach(qw(ei sn tf jp));
}

=head2 getE, getS, getT, getJ, getPrimary

Accessors for the four dimensions and the primary dimension.

=cut

sub getEI { return shift->{ei}; }
sub getSN { return shift->{sn}; }
sub getTF { return shift->{tf}; }
sub getJP { return shift->{jp}; }
sub getPrimary {
	my $self = shift; 
	return $self->{$self->{primary}};
}

=head1 AUTHOR

Johannes Klose, C<< <jk at plusw.de> >>

=head1 COPYRIGHT & LICENSE

Copyright 2007 plusW Rolf Schaufelberger, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1; # End of PWx::TTTResult
