package PWx::WebApp;

use warnings;
use strict;

use Data::FormValidator;
use Data::FormValidator::Constraints qw(:closures);
use PWx::MemberListPlot;

sub Memberlist_Plot {
	my $self = shift;
	
	use Data::Dumper;
	
	if(!$self->session->{users}) {
		$self->abort;
	}
	
	my @users = $self->schema->resultset('Users')->search(id => $self->session->{users});
	
	my $plot;
	eval {
		$plot = new PWx::MemberListPlot(
			xaxis => $self->session->{xaxis},
			yaxis => $self->session->{yaxis},
			users => \@users,
			user  => $self->current_user->getDbObject
		);
	};
	
	if($@) {
		$self->abort;
	}
	
	my $r = $self->apache_req;
	$r->content_type("image/png");
	$r->send_http_header;
	$r->print($plot->data);
	$self->abort;
}

sub Memberlist_Create {
	my $self = shift;
	
	my @users = $self->schema->resultset('Users')->search(undef,
		{
			rows => 20
		})->page(1)->all;
		
	my @userssave;
	
	foreach(@users)
	{
		push @userssave,  $_->id;
	}
	
	my $xaxis = 'EI';
	my $yaxis = 'SN';
	$self->session->{users} = \@userssave;
	$self->session->{xaxis} = $xaxis;
	$self->session->{yaxis} = $yaxis;
	$self->redirect(path => '/members/index.html');
}

sub Memberlist_Refresh {
	my $self = shift;
	
	my $profile = {
		required => [qw(xaxis yaxis)],
		constraint_methods => {
			xaxis => qr/^(EI|SN|TF|JP)$/,
			yaxis => qr/^(EI|SN|TF|JP)$/,
		},
	};

    my $result = Data::FormValidator->check($self->args, $profile);
    
    if ($result->has_missing || $result->has_invalid) {
    	;
    } else {
    	$self->session->{xaxis} = $self->args->{xaxis};
    	$self->session->{yaxis} = $self->args->{yaxis};
    }
	$self->redirect(path => '/members/index.html');	
}

sub Memberlist_Search {
	my $self = shift;
	
	my $profile = {
		optional => [qw(tttei tttsn ttttf tttjp rcdstatusnc rcdstatusnr lifemotto)],
		dependency_groups => {
			ttt => [qw(tttei tttsn ttttf tttjp)],
		},
		constraint_methods => {
			tttei => qr/^(E|I)$/,
			tttsn => qr/^(S|N)$/,
			ttttf => qr/^(T|F)$/,
			tttjp => qr/^(J|P)$/
		},
    };

	my $result = Data::FormValidator->check($self->args, $profile);

	if ($result->has_missing || $result->has_invalid) {
		my %missing = map { $_ => 1 } @{ $result->missing } if $result->has_missing;
		$self->_handle_error(
			uri       => '/members/search.html',
			error     => 'MemberSearch.Failed',
			save_args => {
				missing => \%missing,
				invalid => scalar $result->invalid,
				args    => $self->args
			}
		);
    } else {
    	my %cond;
    	my %joins;
    	
    	if($self->args->{tttei}) {
    		$cond{'result.mbti'} = 
    			 $self->args->{tttei}
    			.$self->args->{tttsn}
    			.$self->args->{ttttf}
    			.$self->args->{tttjp};
    		$joins{result} = 1;
    	}
    	
    	if($self->args->{rcdstatusnc}) {
    		$cond{'rcds.rcd_type_id'} = [1, undef];
    		$joins{rcds} = 1;
    	}
    	
    	if($self->args->{rcdstatusnr}) {
    		$cond{'rcds.rcd_type_id'} = [undef];
    		$joins{rcds} = 1;
    	}
    	
    	if($self->args->{lifemotto}) {
    		$cond{-or} = {
    			life_motto => {'ilike' => '%'.$self->args->{lifemotto}.'%'},
    			life_motto2 => {'ilike' => '%'.$self->args->{lifemotto}.'%'}
    		};
    	}
    	
    	my @users = $self->schema->resultset('Users')->search(\%cond, {join => [keys %joins]});
    	my @userssave = ();
    	
    	push @userssave, $_->id foreach(@users);
    	$self->session->{sresult} = \@userssave;
    	$self->session->{xaxis} = 'EI';
		$self->session->{yaxis} = 'SN';
		$self->session->{args} = $self->args;
		$self->redirect(path => '/members/search.html');
    }
}

1;

__END__

=head1 NAME

PW::App::Memberlist - Backend functions for the memberlist view.

=head1 VERSION

$Id$

=head1 METHODS



=head1 AUTHOR

Johannes Klose, C<< <jk@plusw.de> >>

=head1 COPYRIGHT & LICENSE

Copyright 2007 plusW Rolf Schaufelberger, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.