package PWx::WebApp;

use warnings;
use strict;

use Data::FormValidator;

sub RCD_Accept {
    my $self = shift;

    my $profile = {
                    required           => [qw(id)],
                    optional           => [qw(redirect_to)],
                    constraint_methods => { id => qr/^[0-9]+$/ },
                  };

    my $result = Data::FormValidator->check($self->args, $profile);

    if ($result->has_missing || $result->has_invalid || $self->current_user->is_guest) {
        $self->redirect(uri => "/status/");
    } else {
        my $rcd =
          $self->schema->resultset('Rcds')->search({ id => $self->args->{id} })->single;
        $self->redirect(uri => "/status/") unless $rcd;

        if ($self->current_user->id == $rcd->f_user_id) {
            $rcd->rcd_type_id(2);
            $rcd->update;
        }
        $self->args->{redirect_to}
          ? $self->redirect(uri => $self->args->{redirect_to})
          : $self->redirect(uri => "/status/");
    }
}

sub RCD_Deny {
    my $self = shift;

    my $profile = {
                    required           => [qw(id)],
                    optional           => [qw(redirect_to)],
                    constraint_methods => { id => qr/^[0-9]+$/ },
                  };

    my $result = Data::FormValidator->check($self->args, $profile);

    if ($result->has_missing || $result->has_invalid || $self->current_user->is_guest) {
        $self->redirect(uri => "/status/");
    } else {
        my $rcd =
          $self->schema->resultset('Rcds')->search({ id => $self->args->{id} })->single;
        $self->redirect(uri => "/status/") unless $rcd;

        if ($self->current_user->id == $rcd->f_user_id) {
            $rcd->rcd_type_id(1);
            $rcd->update;
        }
        $self->args->{redirect_to}
          ? $self->redirect(uri => $self->args->{redirect_to})
          : $self->redirect(uri => "/status/");
    }
}

sub RCD_Sent {
    my $self = shift;

    my $profile = {
                    required           => [qw(id)],
                    optional           => [qw(redirect_to)],
                    constraint_methods => { id => qr/^[0-9]+$/ },
                  };

    my $result = Data::FormValidator->check($self->args, $profile);

    if ($result->has_missing || $result->has_invalid || $self->current_user->is_guest) {
        $self->redirect(uri => "/members/");
    } else {
        my $rcd = $self->_RCD_HadContact($self->args->{id});

        if ($rcd) {
            $rcd->rcd_type_id(3);
            $rcd->update;
        } else {
            $self->schema->resultset(
                                     'Rcds')->create(
                                                  {
                                                    rcd_type_id => 3,
                                                    f_user_id => $self->current_user->id,
                                                    t_user_id => $self->args->{id}
                                                  }
                                     );
        }

        $self->args->{redirect_to}
          ? $self->redirect(uri => $self->args->{redirect_to})
          : $self->redirect(uri => "/members/");
    }
}

sub _RCD_HadContact {
    my $self = shift;
    my $id   = shift;

    return 0 unless ($id =~ /^[0-9]+$/);

    return $self->schema->resultset('Rcds')
      ->search({ f_user_id => $self->current_user->id, t_user_id => $id })->single
      ? 1
      : 0;
}

1;

__END__

=head1 NAME

PWx::WebApp::RCD - Dokumentation zu PWx::WebApp::RCD!

=head1 VERSION

$Id$

=head1 METHODS

=head1 AUTHOR

Matthias Dietrich, C<< <md@plusw.de> >>

=head1 COPYRIGHT & LICENSE

Copyright 2006 plusW, Rolf Schaufelberger.  All Rights Reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.
