package org.platforms;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.SessionFactory;
import org.platforms.model.Identifiable;

import java.util.List;
import java.util.Iterator;

import abaxx.core.foundation.internal.dbc.HibernateUtil;
import abaxx.core.foundation.UnexpectedError;
import abaxx.core.foundation.HibernateHelper;

/**
 * Created by IntelliJ IDEA.
 * User: BNSH
 * Date: 18.04.2006
 * Time: 10:10:07
 */
public abstract class AbstractDBManager
{
	protected abstract class HibernateExecuter
	{
		private String queryString;

		public HibernateExecuter(String queryString)
		{
			if ((queryString != null) && (!queryString.equals("")))
			{
				this.queryString = "%" + queryString.toUpperCase() + "%";
			}
		}

		public abstract Query createQuery(Session session, String queryString);

		public List queryList()
		{
			Session session = getSession();
			Transaction tx = HibernateUtil.beginTransaction(session);
			try
			{
				Query query = createQuery(session, queryString);
				List result = query.list();

				HibernateUtil.commit(tx);
				return result;
			}
			catch (Exception exc)
			{
				HibernateUtil.rollback(tx);
				throw UnexpectedError.rethrow(exc);
			}
			finally
			{
				releaseSession(session);
			}

		}

        public Object queryObject()
		{
			List result = this.queryList();

			if (result.size() > 0)
			{
				return result.get(0);
			}
			else
			{
				return null;
			}
		}
	}

	public Object getWithId(final Class clasz, final Long id) {
		return getWithId(clasz.getName(), id);
	}
	public Object getWithId(final String clasz, final Long id) {
	    return new HibernateExecuter(null) {
	        public Query createQuery(Session session, String queryString) {
	            Query query = session.createQuery("from " + clasz +" as obj where obj.id = :id");
	            query.setParameter("id", id);
	            return query;
	        }
	        }.queryObject();
	}

	public synchronized void remove(Object object) {
	    Session session = getSession();
	    Transaction tx  = HibernateUtil.beginTransaction(session);

	    try {
	        session.delete(object);
	        HibernateUtil.commit(tx);
	    } catch (Exception exc) {
	        HibernateUtil.rollback(tx);
	        throw new UnexpectedError(exc);
	    } finally {
	        this.releaseSession(session);
	    }
	}

	public synchronized void removeAll(List list) {
	    Session session = getSession();
	    Transaction tx  = HibernateUtil.beginTransaction(session);

	    try {

            for (Iterator it = list.iterator(); it.hasNext();) {
                Object o = it.next();
                session.delete(o);
            }
            
            HibernateUtil.commit(tx);
	    } catch (Exception exc) {
	        HibernateUtil.rollback(tx);
	        throw new UnexpectedError(exc);
	    } finally {
	        this.releaseSession(session);
	    }
	}

    public synchronized void store(Identifiable identifiable)
	{
		Session session = getSession();
		Transaction tx = HibernateUtil.beginTransaction(session);

		try
		{
			if (identifiable.getId() == null)
				identifiable.setId((Long) session.save(identifiable));
			else
				session.update(identifiable);
			HibernateUtil.commit(tx);
			session.flush();
		}
		catch (Exception exc) {
			HibernateUtil.rollback(tx);
			throw new UnexpectedError(exc);
		}
		finally	{
			releaseSession(session);
		}
	}

    public synchronized void create(Identifiable identifiable)
    {
        Session session = getSession();
        Transaction tx = HibernateUtil.beginTransaction(session);

        try
        {
            identifiable.setId((Long) session.save(identifiable));
            
            HibernateUtil.commit(tx);
            session.flush();
        }
        catch (Exception exc) {
            HibernateUtil.rollback(tx);
            throw new UnexpectedError(exc);
        }
        finally	{
            releaseSession(session);
        }
    }


    protected Session getSession()
	{
		SessionFactory sessionFactory = HibernateHelper.getSessionFactory();
		return sessionFactory.openSession();
	}

	protected void releaseSession(Session session)
	{
		if (session != null)
		{
			session.flush();
			session.close();
		}
	}
}