package org.platforms;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.SessionFactory;
import org.hibernate.Query;
import org.platforms.AbstractDBManager;
import org.platforms.model.*;

import abaxx.core.foundation.Trace;
import abaxx.core.foundation.UnexpectedError;
import abaxx.core.foundation.HibernateHelper;
import abaxx.core.foundation.ClientSession;
import abaxx.core.foundation.internal.dbc.HibernateUtil;
import abaxx.core.security.SecurityContext;

import java.util.*;

/**
  * Manager for Members
 */
public class MemberManager extends AbstractDBManager
{
    private static MemberManager instance;

    public static MemberManager instance() {
        return instance == null ? instance = new MemberManager() : instance;
    }

    public void clearDatabase() {
    	Calendar calendar = new GregorianCalendar();
    	calendar.setTime(new Date());
    	if (calendar.get(Calendar.DAY_OF_MONTH) == 26 && calendar.get(Calendar.MONTH) == 0 ) {
    		return;
    	}
        Session session = getSession();
        Transaction tx  = HibernateUtil.beginTransaction(session);

        try {
            Trace.warn("MemberManager.clearDatabase()", this);
            deleteAll(MemberPreferenceRelation.class, session);
            deleteAll(MemberContact.class, session);
            deleteAll(Member.class, session);
            deleteAll(Preference.class, session);
            session.createSQLQuery("delete from usr_account where id > 1000000").executeUpdate();
            HibernateUtil.commit(tx);
        } catch (Exception exc) {
            HibernateUtil.rollback(tx);
            throw new UnexpectedError(exc);
        } finally {
            this.releaseSession(session);
        }
    }


    private void deleteAll(Class clazz, Session session) {
        int result = 0;
        result = session.createQuery("delete " + clazz.getName()).executeUpdate();
        Trace.warn("Deleted " + result + " entries of " + clazz.getName(), this);
    }

   public static String combineCriterias(List andCriterias) {
        String result = new String();
        for (Iterator it = andCriterias.iterator(); it.hasNext();) {
            String s = (String) it.next();

            result = result + "(" + (s) + ")";

            if (it.hasNext()) {
                result = result + " and ";
            }
        }
        return result;
    }

    public static void addParametersToQuery(Query query, Map parameters) {
        for (Iterator it = parameters.keySet().iterator(); it.hasNext();) {
            String key = (String) it.next();

            query.setParameter(key,parameters.get(key));
        }
    }

    public static List unmarshal(List toUnmarshal,Class clasz) {
        if (toUnmarshal == null) {
            return null;
        }

        //we get here a list of object[] when we join, so unmarshal it
        if (toUnmarshal.size() > 0) {
            if (toUnmarshal.get(0) instanceof Object[]) {
                List newResult = new ArrayList(toUnmarshal.size());

                for (Iterator it = toUnmarshal.iterator(); it.hasNext();) {
                    Object[] objects = (Object[]) it.next();

                    for (int i = 0;i<objects.length;i++) {
                        if ( (objects[i] != null) && (clasz == objects[i].getClass())) {

                            if (! newResult.contains(objects[i])) {
                                 newResult.add(objects[i]);
                            }
                        }
                    }

                }
                return newResult;
            }
        }
        return toUnmarshal;
    }



    public List getContactsToUser(Long referencingUserId, Integer type) {

        String from = "from Member m left outer join m.memberContacts memberContact where " +
                "(memberContact.memberFrom = :memberFrom and memberContact.status = :status)";

        SessionFactory sessionFactory = HibernateHelper.getSessionFactory();
        Session session = sessionFactory.openSession();

        Query query = session.createQuery(from);

        query.setParameter("memberFrom", referencingUserId);

        query.setParameter("status", type);

        List result = query.list();

        result = unmarshal(result,Member.class);

        System.out.println(result.size());

        return result;
    }

    public static final String MYSELF_IN_SESSION = "_MySelfMember";

    public Member getCurrentMember() {
        ClientSession clientSession = ClientSession.current();
		Member member = clientSession == null ? null : (Member) clientSession.getAttribute(MYSELF_IN_SESSION);
        if (member == null) {
            member =  (Member) this.getWithId(Member.class, SecurityContext.current().identity().getIdentifier().asLong());
            if (clientSession != null) {
            	clientSession.setAttribute(MYSELF_IN_SESSION,member);
            }
        }

        return member;
    }

    private static int[] relatedEnneas = new int[] {999,7,4,6,1,8,9,5,2,3};

    public List getRelatedEnneas(int ennea) {
        List result = new ArrayList();
        result.add(new Integer(relatedEnneas[ennea]));

        for (int i = 0; i < relatedEnneas.length; i++ ) {
            if  (relatedEnneas[i] == ennea) {
                result.add(new Integer(i));
                return result;
            }
        }

        return result;
    }

    public List getRelatedEnneas(Member member) {

        List forFirst = this.getRelatedEnneas(member.getEnneagramtype1());

        if (member.getEnneagramtype2() > 0) {
            List forSecond = this.getRelatedEnneas(member.getEnneagramtype2());
            forFirst.addAll(forSecond);
        }

        return forFirst;
    }

    public synchronized void store(Identifiable identifiable) {

        if (identifiable instanceof Member) {
            Member member = (Member) identifiable;

            super.store(identifiable);

            if (member.isLikesLoaded()) {

                List rels = this.getActRelationsFor(member.getId());

                rels = unmarshal(rels,MemberPreferenceRelation.class);

                this.removeAll(rels);

                storePrefs(member.getLikes(), member.getId(),true);
                storePrefs(member.getDislikes(), member.getId(),false);
            }

            if (SecurityContext.current().identity().getIdentifier().asLong().equals(member.getId())) {
                ClientSession.current().removeAttribute(MYSELF_IN_SESSION);
            }

        } else {
            super.store(identifiable);
        }

    }

    private void storePrefs(List likes, Long memberId,boolean like) {
        if (likes == null) {
            return;
        }

        for (Iterator it = likes.iterator(); it.hasNext();) {
            String s = (String) it.next();

            if (s== null || s.trim().length() == 0) {
                it.remove();
            } else {
                Preference pref = getPreference(s);

                if (pref == null) {
                    pref = new Preference();
                    pref.setValue(s);
                    super.store(pref);
                }

                MemberPreferenceRelation relation = new MemberPreferenceRelation();

                relation.setMemberId(memberId);
                relation.setPreferenceId(pref.getId());
                relation.setLike(like);
                super.store(relation);
            }
        }
    }

    private Preference getPreference(final String value) {

        return (Preference)    new HibernateExecuter(null) {
            public Query createQuery(Session session, String queryString) {
                Query q = session.createQuery("from Preference p where p.value = :xxx");
                q.setParameter("xxx",value);
                return q;
            }
        }.queryObject();

    }

    public List getActRelationsFor(final Long userId) {

        return  new HibernateExecuter(null) {
            public Query createQuery(Session session, String queryString) {
                Query q = session.createQuery("from Preference p join p.preferenceRelations rel where rel.memberId = :memberId");
                q.setParameter("memberId",userId);
                return q;
            }
        }.queryList();

    }

   public List getContactsFor(final Long userId) {

        return  new HibernateExecuter(null) {
            public Query createQuery(Session session, String queryString) {
                Query q = session.createQuery("from MemberContact contact where contact.memberFrom = :memberFrom");
                q.setParameter("memberFrom",userId);
                return q;
            }
        }.queryList();
    }

    public MemberContact getContactFor(final Long fromUserId,final Long toUserId) {

         return (MemberContact) new HibernateExecuter(null) {
             public Query createQuery(Session session, String queryString) {
                 Query q = session.createQuery("from MemberContact contact where contact.memberFrom = :memberFrom and contact.memberTo = :memberTo");
                 q.setParameter("memberFrom",fromUserId);
                 q.setParameter("memberTo",toUserId);
                 return q;
             }
         }.queryObject();
     }



    public Object getWithId(final String clasz, final Long id) {

        Object retValue = super.getWithId(clasz, id);

        if (Member.class.getName().equals(clasz)) {
            populateMemberWithLikes((Member)retValue);
        }

        return retValue;
    }

    private void populateMemberWithLikes(Member member) {
        List prefs = this.getActRelationsFor(member.getId());

        member.setLikes(new ArrayList());
        member.setDislikes(new ArrayList());

        for (Iterator it = prefs.iterator(); it.hasNext();) {
            Object[] objs = (Object[]) it.next();
            Preference pref = (Preference) objs[0];
            MemberPreferenceRelation preferenceRelation = (MemberPreferenceRelation) objs[1];

            if (pref.getValue() != null && pref.getValue().trim().length() > 0) {
                if (preferenceRelation.isLike()) {
                    member.getLikes().add(pref.getValue());
                } else {
                    member.getDislikes().add(pref.getValue());
                }
            }
        }
        member.setLikesLoaded(true);
    }


    public Member getMemberByName(final String name) {
        Member member = (Member) new HibernateExecuter(null) {
             public Query createQuery(Session session, String queryString) {
                 Query query = session.createQuery("from Member m where m.username = :username");
                 query.setParameter("username", name);
                 return query;
             }
         }.queryObject();

        if (member != null) {
            this.populateMemberWithLikes(member);
        }

        return member;
    }

    public List getLikesName(final String name) {
        return new HibernateExecuter(null) {
             public Query createQuery(Session session, String queryString) {
                 Query query = session.createQuery("from Preference p where p.value like :name");
                 query.setParameter("name", name);
                 return query;
             }
         }.queryList();
    }


    public void requestContactWithUsernames(Long fromMemberId, List requestTo, boolean incrementRequest) {
        List keys = new ArrayList();

        for (Iterator it = requestTo.iterator(); it.hasNext();) {
            String username = (String) it.next();
            Member member = this.getMemberByName(username);
            if (member != null) {
                keys.add(member.getId());
            }
        }

        this.requestContact(fromMemberId,keys,incrementRequest);
    }


    public void requestContact(Long fromMemberId, List requestTo, boolean incrementRequest) {

        for (Iterator it = requestTo.iterator(); it.hasNext();) {
            Long toKey = (Long) it.next();

            MemberContact contact = this.getContactFor(fromMemberId,toKey);

            if (incrementRequest) {
                if (contact == null) {
                    contact = new MemberContact();
                    contact.setMemberFrom(fromMemberId);
                    contact.setMemberTo(toKey);
                    contact.setStatus(MemberContact.Status.DECLINED);
                }

                if (MemberContact.Status.IN_CONTACT.equals(contact.getStatus())) {
                    // do nothing
                } else if (MemberContact.Status.SENT.equals(contact.getStatus())) {
                    // do nothing
                } else {
                    if (MemberContact.Status.RECEIVED.equals(contact.getStatus())) {
                        contact.setStatus(MemberContact.Status.IN_CONTACT);
                    } else {
                        contact.setStatus(MemberContact.Status.SENT);
                    }
                    contact.setCreationDate(new Date());
                    this.store(contact);

                    updateOppositeContact(contact);
                }
            } else {
                if (contact != null) {

                    if (MemberContact.Status.IN_CONTACT.equals(contact.getStatus())) {
                        // do nothing
                    } else if (MemberContact.Status.SENT.equals(contact.getStatus())) {
                        // do nothing
                    } else if (MemberContact.Status.DECLINED.equals(contact.getStatus())) {
                        // do nothing
                    } else if (MemberContact.Status.RECEIVED.equals(contact.getStatus())) {
                        contact.setStatus(MemberContact.Status.DECLINED);

                        contact.setCreationDate(new Date());
                        this.store(contact);
                        updateOppositeContact(contact);
                    }
                } else {
                    //do nothing
                }
            }
        }

    }

    private void updateOppositeContact(MemberContact contact) {
        MemberContact oppositeContact = this.getContactFor(contact.getMemberTo() ,contact.getMemberFrom());

        if (oppositeContact == null) {
            oppositeContact = new MemberContact();
            oppositeContact.setMemberFrom(contact.getMemberTo());
            oppositeContact.setMemberTo(contact.getMemberFrom());
        }

        if (MemberContact.Status.IN_CONTACT.equals(contact.getStatus())) {
            oppositeContact.setStatus(MemberContact.Status.IN_CONTACT);
        } else if (MemberContact.Status.RECEIVED.equals(contact.getStatus())) {
            oppositeContact.setStatus(MemberContact.Status.SENT);
        } else if (MemberContact.Status.SENT.equals(contact.getStatus())) {
            oppositeContact.setStatus(MemberContact.Status.RECEIVED);
        } else {
            oppositeContact.setStatus(MemberContact.Status.DECLINED);
        }
        contact.setCreationDate(new Date());

        this.store(oppositeContact);
    }

}
