package org.platforms.model;

import java.util.List;
import java.util.Date;

/**
 * @hibernate.class table="PLF_MEMBER"
 */
public class Member implements Identifiable {

    Long id;

    String username;
    String fullname;
    String emailAddress;
    String motto1;
    String motto2;

    String town;
    String country;

    List likes;
    List dislikes;
    String gpsCoordinates;

    int enneagramtype1;
    int enneagramtype2;

    Date registrationDate;
    Date lastVisitDate;

    String tttResult;
    String mbtiType;
    Date tttDate;

    private boolean likesLoaded;


    /**
     * @hibernate.id column="ID" generator-class="assigned"
     */
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

	/**
	 * @hibernate.property
	 */
    public String getFullname() {
        return fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    /**
     * @hibernate.property
     */
    public String getEmailAddress() {
        return emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /**
     * @hibernate.property
     */
    public String getMotto1() {
        return motto1;
    }

    public void setMotto1(String motto1) {
        this.motto1 = motto1;
    }

    /**
     * @hibernate.property
     */
    public String getMotto2() {
        return motto2;
    }

    public void setMotto2(String motto2) {
        this.motto2 = motto2;
    }

    public List getLikes() {
        return likes;
    }

    public void setLikes(List likes) {
        this.likes = likes;
    }

    public List getDislikes() {
        return dislikes;
    }

    public void setDislikes(List dislikes) {
        this.dislikes = dislikes;
    }

    /**
     * @hibernate.property
     */
    public String getGpsCoordinates() {
        return gpsCoordinates;
    }

    public void setGpsCoordinates(String gpsCoordinates) {
        this.gpsCoordinates = gpsCoordinates;
    }

    /**
     * @hibernate.property
     */
    public int getEnneagramtype1() {
        return enneagramtype1;
    }

    public void setEnneagramtype1(int enneagramtype1) {
        this.enneagramtype1 = enneagramtype1;
    }

    /**
     * @hibernate.property
     */
    public int getEnneagramtype2() {
        return enneagramtype2;
    }

    public void setEnneagramtype2(int enneagramtype2) {
        this.enneagramtype2 = enneagramtype2;
    }

    /**
     * @hibernate.property
     */
    public Date getRegistrationDate() {
        return registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    /**
     * @hibernate.property
     */
    public Date getLastVisitDate() {
        return lastVisitDate;
    }

    public void setLastVisitDate(Date lastVisitDate) {
        this.lastVisitDate = lastVisitDate;
    }

    /**
     * @hibernate.property
     */
    public String getTttResult() {
        return tttResult;
    }

    public void setTttResult(String tttResult) {
        this.tttResult = tttResult;
    }

    /**
     * @hibernate.property
     */
    public String getMbtiType() {
        return mbtiType;
    }

    public void setMbtiType(String mbtiType) {
        this.mbtiType = mbtiType;
    }

    /**
     * @hibernate.property
     */
    public Date getTttDate() {
        return tttDate;
    }

    public void setTttDate(Date tttDate) {
        this.tttDate = tttDate;
    }

    /**
     * @hibernate.property
     */
    public String getTown() {
        return town;
    }

    public void setTown(String town) {
        this.town = town;
    }

    /**
     * @hibernate.property
     */
    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    /**
     * @hibernate.property
     */
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    private List memberContacts;
    /**
     * @hibernate.bag name="memberContacts" lazy="true" inverse="true" cascade="delete" outer-join="true"
     * @hibernate.collection-key column="memberto"
     * @hibernate.collection-one-to-many class="org.platforms.model.MemberContact"
     */
    public List getMemberContacts() {
        return memberContacts;
    }

    public void setMemberContacts(List memberContacts) {
        this.memberContacts = memberContacts;
    }


    private List memberReferenceRelations;
    /**
     * @hibernate.bag name="memberReferenceRelations" lazy="true" inverse="true" cascade="delete" outer-join="false"
     * @hibernate.collection-key column="memberId"
     * @hibernate.collection-one-to-many class="org.platforms.model.MemberPreferenceRelation"
     */
    public List getMemberReferenceRelations() {
        return memberReferenceRelations;
    }

    public void setMemberReferenceRelations(List memberReferenceRelations) {
        this.memberReferenceRelations = memberReferenceRelations;
    }


    public boolean isLikesLoaded() {
        return likesLoaded;
    }

    public void setLikesLoaded(boolean likesLoaded) {
        this.likesLoaded = likesLoaded;
    }

	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		if (!(obj instanceof Member)) {
			return false;
		}
		Member other = (Member)obj;
		if (this.id == null || other.id == null) {
			return false;
		}
		return this.id.equals(other.id);
	}

    public String getCombinedMottos() {
        String result = null;

        if (this.motto1 != null) {
            result = motto1;
        }

        if (this.motto2 != null ) {
            if (result == null) {
                result = motto2;
            } else {
                result = result + " " + motto2;
            }
        }

        return result;
    }

    public void setCombinedMottos(String combinedMottos) {

    }


	public int hashCode() {
		return this.id == null ? super.hashCode() : id.hashCode();
	}

    

}
