package org.platforms.model;

import java.util.Date;

import abaxx.core.foundation.Trace;
import abaxx.core.foundation.UnexpectedError;

/**
 * @hibernate.class table="PLF_MEMBER_CONTACT"
 */
public class MemberContact  implements Identifiable {

    public static class Status {
		public static final Integer NO_CONTACT = new Integer(0);
        public static final Integer SENT = new Integer(1);
        public static final Integer RECEIVED = new Integer(2);
        public static final Integer IN_CONTACT = new Integer(3);
        public static final Integer DECLINED = new Integer(4);

        public static final String SENT_STRING = "RCD_sent";
        public static final String RECEIVED_STRING = "RCD_received";
        public static final String IN_CONTACT_STRING = "in_contact";
        
        public static final int SENT2 = 1;
	    public static final int RECEIVED2 = 2;
	    public static final int IN_CONTACT2 = 3;
	    public static final int DECLINED2 = 4;
	    
	    public static  Integer fromString(String status) {
	    	if (SENT_STRING.equals(status)) {
	    		return SENT;
	    	} else if (RECEIVED_STRING.equals(status)) {
	    		return RECEIVED;
	    	} else if (IN_CONTACT_STRING.equals(status)) {
	    		return IN_CONTACT;
	    	} else {
	    		Trace.error("unknown String "+status, MemberContact.class);
	    		return null;
	    	}
	    }
    }

    Long id;

    Long memberFrom;
    Long memberTo;

    Integer status;  //1 sent,  2 received, 3 in contact, 4 declined

    boolean initiated; //by from

    Date creationDate;


    /**
     * @hibernate.id column="ID" generator-class="abaxx.core.foundation.HibernateIdentifierGenerator"
     */
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @hibernate.property
     */
    public Long getMemberFrom() {
        return memberFrom;
    }

    public void setMemberFrom(Long memberFrom) {
        this.memberFrom = memberFrom;
    }

    /**
     * @hibernate.property
     */
    public Long getMemberTo() {
        return memberTo;
    }

    public void setMemberTo(Long memberTo) {
        this.memberTo = memberTo;
    }

    /**
     * @hibernate.property
     */
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * @hibernate.property
     */
    public boolean isInitiated() {
        return initiated;
    }

    public void setInitiated(boolean initiated) {
        this.initiated = initiated;
    }

    /**
     * @hibernate.property
     */
    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }


}
