package org.platforms.model;

import java.util.List;

/**
 * @hibernate.class table="PLF_PREFERENCE"
 */

public class Preference  implements Identifiable {
    Long id;
    String value;

    /**
     * @hibernate.id column="ID" generator-class="abaxx.core.foundation.HibernateIdentifierGenerator"
     */
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @hibernate.property
     */    
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private List preferenceRelations;

    /**
     * @hibernate.bag name="preferenceRelations" lazy="true" inverse="true" cascade="delete" outer-join="false"
     * @hibernate.collection-key column="preferenceId"
     * @hibernate.collection-one-to-many class="org.platforms.model.MemberPreferenceRelation"
     */
    public List getPreferenceRelations() {
        return preferenceRelations;
    }

    public void setPreferenceRelations(List preferenceRelations) {
        this.preferenceRelations = preferenceRelations;
    }



}
