package org.platforms.chart;

import ChartDirector.*;
import abaxx.web.aspects.*;
import abaxx.web.control.RequestProcessor;
import abaxx.web.parts.RequestContext;
import abaxx.core.users.UserRegistry;
import abaxx.core.users.UserAccount;

import javax.servlet.ServletException;
import java.util.*;

import org.platforms.gps.GpsConverter;
import org.platforms.model.MemberContact;
import org.platforms.model.Member;
import org.platforms.MemberManager;
import org.platforms.ttt.TttResult;
import org.platforms.user.ContactLists;

/**
 * Created by IntelliJ IDEA.
 * User: DKFL
 * Date: 25.01.2007
 * Time: 14:43:25
 * To change this template use File | Settings | File Templates.
 */
public class ChartController implements IController, IController.Callbacks {

	static final Random scatter = new Random(System.currentTimeMillis());

	private XYChart chart = null;
	protected Member currentMember = null;

	public ActionResult action(Request request, AspectModel model) throws ServletException {
		if ("refresh".equals(request.event()))
			return onRefresh(request, model);
		if ("draw".equals(request.event()))
			return onDraw(request, model);
		return ActionResult.SUCCEEDED;
	}

	private ActionResult onDraw(Request request, AspectModel model) {
		bundle = I18nResources.instanceFor("org.platforms.chart.Chart", null, request).getResourceBundle();
		ChartModel m = (ChartModel)request.getRequest().getAttribute("chartModel");
		currentMember = MemberManager.instance().getCurrentMember();
		createChart(m, 850, 500);

		return null;
	}

	// default
	ResourceBundle bundle = ResourceBundle.getBundle("org.platforms.chart.Chart", Locale.ENGLISH);

	private ActionResult onRefresh(Request request, AspectModel model) {
		bundle = I18nResources.instanceFor("org.platforms.chart.Chart", null, request).getResourceBundle();
		ChartModel m = (ChartModel) model.get(true);
		ContactLists contactLists = ContactLists.instanceFor(request.getSession());
		m.setStatusLists(contactLists.asStatusLists());
		createOverviewChart(m, 850, 500);

		return null;
	}

	public XYChart createOverviewChart(ChartModel m, int x, int y) {
/*
		UserAccount currentUser = UserRegistry.currentUser();
		Long userId = currentUser.getIdentifier().asLong();
		MemberManager man = MemberManager.instance();

		StatusLists statusLists = new StatusLists();
		statusLists.getSent().addAll(man.getContactsToUser(userId, MemberContact.Status.SENT));
		statusLists.getInContacts().addAll(man.getContactsToUser(userId, MemberContact.Status.IN_CONTACT));
		statusLists.getI
		m.setInContact(man.getContactsToUser(userId, MemberContact.Status.IN_CONTACT));
		m.setDeclined(man.getContactsToUser(userId, MemberContact.Status.DECLINED));
		m.setReceived(man.getContactsToUser(userId, MemberContact.Status.RECEIVED));
		m.setNoContact(new ArrayList());
		m.setStatusLists(statusLists);
*/
		return createChart(m, x, y);
	}

	public XYChart createChart(ChartModel m, int x, int y) {
		chart = new XYChart(x, y);

// Set the plotarea at (55, 65) and of size 350 x 300 pixels, with a light grey
// border (0xc0c0c0). Turn on both horizontal and vertical grid lines with light grey
// color (0xc0c0c0)
		chart.setPlotArea(55, 95, x-50, y-200, -1, -1, 0xc0c0c0, 0xc0c0c0, -1);

// Add a legend box at (50, 30) (top of the chart) with horizontal layout. Use 12 pts
// Times Bold Italic font. Set the background and border color to Transparent.
		chart.addLegend(50, 30, false, "Times New Roman Bold Italic", 12).setBackground(
				Chart.Transparent);

// Add a title to the chart using 18 pts Times Bold Itatic font.
		chart.addTitle("Member List Overview", "Times New Roman Bold Italic", 14);

		chart.yAxis().setTitle(bundle.getString("yAxis.value." + m.getyAxis()), "Arial Bold Italic", 10);
		chart.xAxis().setTitle(bundle.getString("yAxis.value." +  m.getxAxis()), "Arial Bold Italic", 10);
		adjustAxis(chart.yAxis(), m.getyAxis());
		adjustAxis(chart.xAxis(), m.getxAxis());

// Set the axes line width to 3 pixels
		chart.xAxis().setWidth(3);
		chart.yAxis().setWidth(3);

		UserAccount currentUser = UserRegistry.currentUser();
		Long userId = currentUser.getIdentifier().asLong();
		MemberManager man = MemberManager.instance();

		addScatterLayer(chart, m, Collections.singletonList(man.getWithId(Member.class, userId)), -2); // self
		if (m.getNoContact() != null && m.getNoContact().size() > 0) addScatterLayer(chart, m, m.getNoContact(), -1); // no contact
		if (m.getInContact() != null && m.getInContact().size() > 0)addScatterLayer(chart, m, m.getInContact(), MemberContact.Status.IN_CONTACT2);
		if (m.getSent() != null && m.getSent().size() > 0)addScatterLayer(chart, m, m.getSent(), MemberContact.Status.SENT2);
		if (m.getReceived() != null && m.getReceived().size() > 0)addScatterLayer(chart, m, m.getReceived(), MemberContact.Status.RECEIVED2);
		//addScatterLayer(chart, m, m.getDeclined(), MemberContact.Status.DECLINED2);
		return chart;
	}

	private void addScatterLayer(XYChart c, ChartModel m, List users, int type) {
		ExtractedData data = extractData(users, m.getxAxis(), m.getyAxis());
		int symbol;
		int color;
		switch(type) {
			case -2: symbol=Chart.DiamondSymbol; color=0x006DBD; break; // blue diamond
			case MemberContact.Status.DECLINED2:
			case -1: symbol=Chart.CrossSymbol; color=0x000000; break; // black cross
			case MemberContact.Status.IN_CONTACT2: symbol=Chart.CircleSymbol; color=0x31FF31; break; // green circle
			case MemberContact.Status.SENT2: symbol=Chart.TriangleSymbol; color=0xFF0000; break; // red triangle
			case MemberContact.Status.RECEIVED2:symbol=Chart.LeftTriangleSymbol; color=0x630C7B; break; // violet triangle
			default:symbol=Chart.RightTriangleSymbol; color=0;
		}
		ScatterLayer layer = c.addScatterLayer(data.datax, data.datay, bundle.getString("layer.value."+type), symbol, 10, color);
		layer.addExtraField(data.names);
		layer.setDataLabelFormat("{field0}");
		layer.addExtraField(data.ids);
	}

	public final static class ExtractedData {
		double[] datax;
		double[] datay;
		String[] names;
		double[] ids;
	}
	private ExtractedData extractData(List users, String typeX, String typeY) {
		ExtractedData result = new ExtractedData();
		result.datax = new double[users.size()];
		result.datay = new double[users.size()];
		result.names = new String[users.size()];
		result.ids = new double[users.size()];
		for (int i = 0; i < users.size(); i++) {
			Member member = (Member) users.get(i);
			TttResult r = new TttResult(member.getTttResult(), true);
			result.datax[i] = extractValue(member, r, typeX);
			result.datay[i] = extractValue(member, r, typeY);
			result.names[i] = member.getUsername();
			result.ids[i] = member.getId().longValue();
		}
		return result;
	}

	private void adjustAxis(Axis axis, String type) {
		if (type.equals("E-I")|| type.equals("S-N") || type.equals("T-F") || type.equals("J-P"))
			axis.setLinearScale(-20, 20);
		if (type.equals("SJ") || type.equals("SP") || type.equals("NT") || type.equals("NF"))
			axis.setLinearScale(-40, 40);
		if (type.equals("distance-to-member"))
			axis.setLinearScale(0, 10000);
	}

	public static double scatter(double orignal) {
		return (orignal + ((double)(33-scatter.nextInt(66))/100));
	}
	private double extractValue(Member member, TttResult result, String type) {
		if (type.equals("E-I")) {
			return scatter(result.getI()) ;
		} else if (type.equals("S-N")) {
			return scatter(result.getS());
		} else
		if (type.equals("T-F")) {
			return scatter(result.getT());
		} else
		if (type.equals("J-P")) {
			return scatter(result.getJ());
		} else
		if (type.equals("SJ")) {
			return scatter(result.getSJ());
		} else
		if (type.equals("SP")) {
			return scatter(result.getSP());
		} else
		if (type.equals("NT")) {
			return scatter(result.getNT());
		} else
		if (type.equals("NF")) {
			return scatter(result.getNF());
		} else
		if (type.equals("distance-to-member")) {
			if (currentMember == null) {
				currentMember = MemberManager.instance().getCurrentMember();
			}
			double distance = GpsConverter.distance(currentMember, member);
			if (distance < 0) {
				return scatter(10000); // infinite
			}
			return scatter(distance);
		} else
		if (type.equals("like-overlap")) {
			return scatter(0); // todo
		} else
		if (type.equals("membership-age")) {
			return scatter(member.getRegistrationDate().getTime());
		} else
		if (type.equals("TTT-age")) {
			return member.getTttDate() != null ? scatter(member.getTttDate().getTime()) : scatter(0);
		}
		return 0;
	}

	public String getChartUri(RequestContext request) {
		return chart != null ? chart.makeSession(RequestProcessor.currentRequest().getRequest(), "chart1") : null;
	}

	public String getImageMap(RequestContext request) {
		ChartModel m = (ChartModel)AspectModel.get(request);
		return chart != null ? chart.getHTMLImageMap(
				request.eventTo("self", "pick", true).addParam("id", "").asRedirect().toString()+"{field1}",
			    "", "title='[{dataSetName}] " + bundle.getString("yAxis.value." + m.getxAxis())+ " = {x}, " + bundle.getString("yAxis.value." + m.getyAxis()) + " = {value}'") : null;
	}

	public void onInitialize(Request request) throws ServletException {
		bundle  = I18nResources.instanceFor("org.platforms.chart.Chart", null, RequestProcessor.currentRequest()).getResourceBundle();
	}

	public void onDisplay(Request request) throws ServletException {
		if (AspectModel.get(request) == null)
			AspectModel.set(new ChartModel(), request);
	}

	public XYChart getChart() {
		return chart;
	}
}
