package org.platforms.gps;

import org.platforms.model.Member;

/**
 * Created by IntelliJ IDEA.
 * User: DKFL
 * Date: 26.01.2007
 * Time: 10:19:22
 * To change this template use File | Settings | File Templates.
 */
public class GpsConverter {

	public static double getLatitude(String gpspos) {
		if (gpspos.toLowerCase().contains("n")) {
			return Double.parseDouble(gpspos.substring(0, gpspos.toLowerCase().indexOf("n")));
		} else {
			return -Double.parseDouble(gpspos.substring(0, gpspos.toLowerCase().indexOf("s")));
		}
	}

	public static double getLongitude(String gpspos) {
		if (gpspos.toLowerCase().contains("e")) {
			return Double.parseDouble(gpspos.substring(gpspos.indexOf(",")+1, gpspos.toLowerCase().indexOf("e")));
		} else {
			return -Double.parseDouble(gpspos.substring(gpspos.indexOf(",")+1, gpspos.toLowerCase().indexOf("w")));
		}
	}

	// distance in KM
	public static double distance(Member m1, Member m2) {
		String gps1 = m1.getGpsCoordinates();
		String gps2 = m2.getGpsCoordinates();
		if (gps1 == null || "".equals(gps1) 
				|| gps2 == null || "".equals(gps2)) {
			return -1;
		}
		double dx = getLatitude(gps1) - getLatitude(gps2);
		double dy = getLongitude(gps1) - getLongitude(gps2);
		return 100 * Math.sqrt(dx * dx + dy * dy);
		
	}
	
}
