package org.platforms.search.ui;

import abaxx.web.aspects.IController;
import abaxx.web.aspects.ActionResult;
import abaxx.web.aspects.Request;
import abaxx.web.aspects.AspectModel;
import abaxx.web.widgets.Table;
import abaxx.web.widgets.DefaultTableModel;
import abaxx.core.foundation.HibernateHelper;
import abaxx.core.foundation.UnexpectedError;
import abaxx.core.foundation.Trace;
import abaxx.core.security.SecurityContext;
import abaxx.basics.Basics;

import javax.servlet.ServletException;

import org.platforms.model.Member;
import org.platforms.model.MemberContact;
import org.platforms.model.MemberPreferenceRelation;
import org.platforms.MemberManager;
import org.platforms.gps.GpsConverter;
import org.platforms.user.MemberListModel;
import org.hibernate.SessionFactory;
import org.hibernate.Session;
import org.hibernate.Query;

import java.util.*;

/**
 * User: BDMR
 * Date: 25.01.2007
 */
public class SearchController implements IController, IController.Callbacks {

   Member me = null;

    public interface Postfilter {
        void filter(List toFilter);
    }

    public ActionResult action(Request request, AspectModel aspectModel) throws ServletException {
        String event = request.event();

        if ("search".equals(event) ) {
            return this.doSearch(request, aspectModel);
        }


        return ActionResult.SUCCEEDED;
    }

    private ActionResult doSearch(Request request, AspectModel aspectModel) {

        me = MemberManager.instance().getCurrentMember();

        SearchModel model = (SearchModel)  aspectModel.get(true);

        //bugfix
        if (request.getParameter("tttType") == null) {
            model.getTttType().clearSelection();
        }
        List result = null;
        try {
        	result = search(model,me);
        } catch (Exception ve) {
            Trace.error(ve,this);
            aspectModel.errors().add(null,"search.selectCriteria");
            return ActionResult.FAILED;
        }

        if (result.size() == 0) {
            aspectModel.errors().add(null,"search.noResult");
            return ActionResult.FAILED;
        }

        request.getRequest().setAttribute("model", new MemberListModel(result));

        return ActionResult.SUCCEEDED;

    }

	public List search(SearchModel model,Member forMember) {

        boolean joinContact = false;

        List andCriterias = new ArrayList();
        Map parameters = new HashMap();

        if (model.isNotMyContacts()) {
            joinContact = true;
            String q = "(memberContact.memberFrom = :memberFrom and memberContact.status != :status) or (memberContact.memberFrom is null and memberContact.status is null)";
            andCriterias.add(q);

            parameters.put("memberFrom",SecurityContext.current().identity().getIdentifier().asLong());
            parameters.put("status",MemberContact.Status.IN_CONTACT);
        }

        if (model.isNotReceivedAnRcd ()) {
            joinContact = true;
            String q = "(memberContact.memberFrom = :memberFrom2 and memberContact.status != :status2 and memberContact.status != :status3)" +
                    " or (memberContact.memberFrom is null and memberContact.status is null)";
            andCriterias.add(q);

            parameters.put("memberFrom2", SecurityContext.current().identity().getIdentifier().asLong());
            parameters.put("status2",MemberContact.Status.IN_CONTACT);
            parameters.put("status3",MemberContact.Status.SENT);
        }


        if (model.getTttType().getSelections().size() > 0) {

            String types = "'" + Basics.toString(model.getTttType().getSelections(),"','",false) + "'";

            String q = "m.mbtiType in (" + types + ")";
            andCriterias.add(q);
        }

        if (model.getLifeMotto() != null && model.getLifeMotto().length() > 0) {
            String q = "(m.motto1 like :motto1) or (m.motto2 like :motto2)";
            andCriterias.add(q);

            parameters.put("motto1","%" + model.getLifeMotto() + "%");
            parameters.put("motto2","%" + model.getLifeMotto() + "%");
        }


        if (model.getRegisteredDuring().getSelectionIndex() > 0  ) {
            String q = "(m.registrationDate > :registrationDate)";
            andCriterias.add(q);

            if (model.getRegisteredDuring().getSelectionIndex() == 1 ) {
                parameters.put("registrationDate", forMember.getLastVisitDate());
            } else {
                Calendar cal = new GregorianCalendar();
                cal.setTime(new Date());

                int days = ((Integer)model.getRegisteredDuring().getSelection()).intValue();

                cal.add(Calendar.DAY_OF_MONTH,  days * -1 );

                parameters.put("registrationDate", cal.getTime());
            }
        }

        if (model.getDoneTTTDuring().getSelectionIndex() > 0  ) {
            String q = "(m.tttDate > :tttDate)";
            andCriterias.add(q);

            if (model.getDoneTTTDuring().getSelectionIndex() == 1 ) {
                parameters.put("tttDate", forMember.getLastVisitDate());
            } else {
                Calendar cal = new GregorianCalendar();
                cal.setTime(new Date());

                int days = ((Integer)model.getDoneTTTDuring().getSelection()).intValue();

                cal.add(Calendar.DAY_OF_MONTH,  days * -1 );

                parameters.put("tttDate", cal.getTime());
            }
        }

        if (model.isOnlyMembersInMyCountry()) {
            String q = "(m.country = :country)";
            andCriterias.add(q);

            parameters.put("country",forMember.getCountry());
        }

        if (model.isSameEnneagram()) {
            String q = "(m.enneagramtype1 = :enneagramtype1)";
            andCriterias.add(q);

            parameters.put("enneagramtype1",new Integer(forMember.getEnneagramtype1()));
        }

        if (model.isOneOfMineEnneagram ()) {
            String q = "(m.enneagramtype1 = :ennea1) or (m.enneagramtype2 = :ennea2) ";
            parameters.put("ennea1",new Integer(forMember.getEnneagramtype1()));
            parameters.put("ennea2",new Integer(forMember.getEnneagramtype1()));

            if (forMember.getEnneagramtype2() > 0) {
                q = q + " or (m.enneagramtype1 = :ennea3) or (m.enneagramtype2 = :ennea4)";
                parameters.put("ennea3",new Integer(forMember.getEnneagramtype2()));
                parameters.put("ennea4",new Integer(forMember.getEnneagramtype2()));
            }

            andCriterias.add(q);
        }

        if (model.isRelatedEnneagram()) {
            List emmeas = MemberManager.instance().getRelatedEnneas(MemberManager.instance().getCurrentMember());

            String q = "";

            for (Iterator it = emmeas.iterator(); it.hasNext();) {
                Integer emmea = (Integer) it.next();

                if (q.length() > 0) {
                    q = q + " or ";
                }

                q = q + "(m.enneagramtype1 = " + emmea + ") or (m.enneagramtype2 = " + emmea + ") ";
            }

            andCriterias.add(q);
        }

        boolean joinPreference = false;

        if (model.getShareMyLikes().getSelectionIndex() > 0) {
            Integer nums = (Integer)model.getShareMyLikes().getSelection();

            List preferenceKeys = getReferencekeys(forMember,true);

            joinPreference = true;

            String likes  =  Basics.toString(preferenceKeys,",",false);

            String q = "preferenceRelation.preferenceId in (" + likes + ") and preferenceRelation.like = true ";
            andCriterias.add(q);
        }

        if (model.getShareMyDislikes().getSelectionIndex() > 0) {
            Integer nums = (Integer)model.getShareMyDislikes().getSelection();

            List preferenceKeys = getReferencekeys(forMember,false);

            joinPreference = true;

            String likes  =  Basics.toString(preferenceKeys,",",false);

            String q = "preferenceRelation.preferenceId in (" + likes + ") and preferenceRelation.like = false ";
            andCriterias.add(q);
        }

        if (model.getDislikeNoneOfLikes().getSelectionIndex() > 0) {
            Integer nums = (Integer)model.getDislikeNoneOfLikes().getSelection();

            List preferenceKeys = getReferencekeys(forMember,true);

            joinPreference = true;

            String likes  =  Basics.toString(preferenceKeys,",",false);

            String q = "preferenceRelation.preferenceId in (" + likes + ") and preferenceRelation.like = false ";
            andCriterias.add(q);
        }

        if (model.getLikeNoneOfMyDislikes().getSelectionIndex() > 0) {
            Integer nums = (Integer)model.getLikeNoneOfMyDislikes().getSelection();

            List preferenceKeys = getReferencekeys(forMember,false);

            joinPreference = true;

            String likes  =  Basics.toString(preferenceKeys,",",false);

            String q = "preferenceRelation.preferenceId in (" + likes + ") and preferenceRelation.like = true ";
            andCriterias.add(q);
        }

        boolean gpscheck = false;

        if (model.getLiveAround().getSelectionIndex() > 0 ) {
            //we do a postfiltering...ok, it is not nice, but what else should we do
            gpscheck = true;
        }


        String from = "from Member m";

        if (joinContact) {
            from = from + " left outer join m.memberContacts memberContact";
        }
        if (joinPreference) {
            from = from + " join m.memberReferenceRelations preferenceRelation";
        }


        if ((andCriterias.size() == 0) && (!gpscheck) ) {
        	throw new UnexpectedError("search.selectCriteria");
        }

        //don't find self
        String q = "(m.id != :id1)";
        andCriterias.add(q);
        parameters.put("id1",forMember.getId());

        from = from + " where " + MemberManager.combineCriterias(andCriterias);

        SessionFactory sessionFactory = HibernateHelper.getSessionFactory();
        Session session = sessionFactory.openSession();

        System.out.println(from);

        Query query = session.createQuery(from);

        MemberManager.addParametersToQuery (query,parameters);

        List result = query.list();

        result = MemberManager.unmarshal(result,Member.class);


        if (gpscheck) {

            int around = ((Integer) model.getLiveAround().getSelection()).intValue();

            for (Iterator it = result.iterator(); it.hasNext();) {
                Member member = (Member) it.next();

                double dist = GpsConverter.distance(forMember,member);

                if ((dist > around) || (dist < 0)) {
                    it.remove();
                }
            }
        }

        return result;
	}

    private List getReferencekeys(Member member,boolean likes) {
        List rels = MemberManager.instance().getActRelationsFor(member.getId());

        rels = MemberManager.unmarshal(rels, MemberPreferenceRelation.class);

        List preferenceKeys = new ArrayList();

        for (Iterator it = rels.iterator(); it.hasNext();) {
            MemberPreferenceRelation relationo = (MemberPreferenceRelation) it.next();

            if (relationo.isLike()  == likes) {
                preferenceKeys.add(relationo.getPreferenceId());
            }
        }
        return preferenceKeys;
    }


    public void onInitialize(Request request) throws ServletException {
        AspectModel.set(new SearchModel(),request);

        this.me = MemberManager.instance().getCurrentMember();
    }

    public void onDisplay(Request request) throws ServletException {
	    this.me = MemberManager.instance().getCurrentMember();
    }

    public boolean isCountrySearchValid() {
        return this.me.getCountry() != null;
    }

    public boolean isLiveAroundSearchValid() {
        return this.me.getGpsCoordinates() != null;
    }

    public boolean isMyLikeseSearchValid() {
        return (this.me.getLikes() != null) && (this.me.getLikes().size() > 0);
    }

    public boolean isMyDislikesSearchValid() {
        return (this.me.getDislikes() != null) && (this.me.getDislikes().size() > 0);
    }



}
