package org.platforms.ttt;

import abaxx.web.aspects.*;

import javax.servlet.ServletException;

/**
 * Created by IntelliJ IDEA.
 * User: DKFL
 * Date: 25.01.2007
 * Time: 12:33:59
 * To change this template use File | Settings | File Templates.
 */
public class TttQuestionController implements IController, IController.Callbacks {

	private boolean testDone = false;

	public ActionResult action(Request request, AspectModel model) throws ServletException {
		if ("start".equals(request.event())) {
			return onStart(request, model);
		}
		if ("vote".equals(request.event())) {
			return onVote(request, model);
		}
		if ("abort".equals(request.event())) {
			return onAbort(request, model);
		}
		return null;
	}

	private ActionResult onAbort(Request request, AspectModel model) {
		testDone = false;
		model.set(null);
		return ActionResult.SUCCEEDED;
	}

	private ActionResult onVote(Request request, AspectModel model) {
		TttResult r = (TttResult) model.get();
		for (int i = 1; i <= 41; i++) {
			String vote = request.getParameter("question" + i);
			try {
				r.vote(vote);
			} catch (IllegalArgumentException iae) {
				return ActionResult.FAILED;
			}

		}
		if (!r.voteValid()) {
			model.errors().add(null, "toofewanswers.error");
			return ActionResult.FAILED;
		}
		testDone = true;
		return ActionResult.forwardTo("self", "update").addParam("tttResult", r.getNormalizedResult());
	}

	private ActionResult onStart(Request request, AspectModel model) {
		testDone = false;
		model.set(new TttResult());
		return ActionResult.SUCCEEDED;
	}

	public void onInitialize(Request request) throws ServletException {
		AspectModel.set(new TttResult(), request);
	}

	public void onDisplay(Request request) throws ServletException {
   	    if (AspectModel.get(request) == null)
		      AspectModel.set(new TttResult(), request);
	}

	public boolean getTestDone() {
		return testDone;
	}
}
