package org.platforms.ttt;

import java.util.StringTokenizer;

/**
 * Created by IntelliJ IDEA.
 * User: DKFL
 * Date: 25.01.2007
 * Time: 12:02:55
 * To change this template use File | Settings | File Templates.
 */
public class TttResult {

	private int I;
	private int S;
	private int T;
	private int J;

	private String result = "";

	public TttResult() {

	}

	public TttResult(String fromString, boolean cumulated) {
		if (fromString == null) return;
		fromString = fromString.trim();
		if (cumulated) {
			StringTokenizer token = new StringTokenizer(fromString, "IESNTFJP+");
			if (fromString.indexOf("I") >= 0)
				I = Integer.parseInt(token.nextToken());
			else
				I = -Integer.parseInt(token.nextToken());
			if (fromString.indexOf("S") >= 0)
				S = Integer.parseInt(token.nextToken());
			else
				S = -Integer.parseInt(token.nextToken());
			if (fromString.indexOf("T") >= 0)
				T = Integer.parseInt(token.nextToken());
			else
				T = -Integer.parseInt(token.nextToken());
			if (fromString.indexOf("J") >= 0)
				J = Integer.parseInt(token.nextToken());
			else
				J = -Integer.parseInt(token.nextToken());
		} else {
			char[] chars = fromString.toCharArray();
			for (int i = 0; i < chars.length; i++) {
				vote(""+chars[i]);
			}
		}
	}

	public String getNormalizedResult() {
		return  (I >= 0 ? "I+"+I : "E+"+(-I)) +
				(S >= 0 ? "S+"+S : "N+"+(-S)) +
				(T >= 0 ? "T+"+T : "F+"+(-T)) +
				(J >= 0 ? "J+"+J : "P+"+(-J));
	}

	public String getMbtiResult() {
		return  (I >= 0 ? "I" : "E") +
				(S >= 0 ? "S" : "N") +
				(T >= 0 ? "T" : "F") +
				(J >= 0 ? "J" : "P");
	}

	public String getKeirseyResult() {
		return mbtiToKeirsey(getMbtiResult());
	}

	public static String mbtiToKeirsey(String mbti) {
		if (mbti.indexOf("S") >= 0) {
			if (mbti.indexOf("J") >= 0)
				return "SJ";
			else
				return "SP";
		} else {
			if (mbti.indexOf("T") >= 0)
				return "NT";
			else
				return "NF";
		}
	}

	public boolean voteValid() {
		int votedI = 0;
		int votedS = 0;
		int votedT = 0;
		int votedJ = 0;
		char[] votes = result.toCharArray();
		for (int i= 0; i<votes.length; i++) {
			if (votes[i] == 'I' || votes[i] == 'E') votedI++;
			else if (votes[i] == 'S' || votes[i] == 'N') votedS++;
			else if (votes[i] == 'T' || votes[i] == 'F') votedT++;
			else if (votes[i] == 'J' || votes[i] == 'P') votedJ++;
		}

		return votedI >= 5 && votedS >= 5 && votedT >= 5 && votedJ >= 5;
	}

	public void voteNot() {
		result += " ";
	}
	public void voteE() {
		result += "E";
		I--;
	}
	public void voteI() {
		result += "I";
		I++;
	}
	public void voteS() {
		result += "S";
		S++;
	}
	public void voteN() {
		result += "N";
		S--;
	}
	public void voteT() {
		result += "T";
		T++;
	}
	public void voteF() {
		result += "F";
		T--;
	}
	public void voteJ() {
		result += "J";
		J++;
	}
	public void voteP() {
		result += "P";
		J--;
	}

	public int getI() {
		return I;
	}

	public int getJ() {
		return J;
	}

	public int getS() {
		return S;
	}

	public int getT() {
		return T;
	}

	public int getSJ() {
		return S+J;
	}

	public int getSP() {
		return S-J;
	}

	public int getNT() {
		return -S+T;
	}

	public int getNF() {
		return -S-T;
	}

	public String getResult() {
		return result;
	}

	public static void main(String[] args) {
		TttResult r = new TttResult("E+4S+5T+1J+0", true);
		System.out.println("" + r.getI() + r.getS() + r.getT() + r.getJ());
	}

	public void vote(String vote) {
		if (vote == null || vote.equalsIgnoreCase(" "))
			voteNot();
		else if (vote.equalsIgnoreCase("E"))
			voteE();
		else if (vote.equalsIgnoreCase("F"))
			voteF();
		else if (vote.equalsIgnoreCase("I"))
			voteI();
		else if (vote.equalsIgnoreCase("J"))
			voteJ();
		else if (vote.equalsIgnoreCase("N"))
			voteN();
		else if (vote.equalsIgnoreCase("P"))
			voteP();
		else if (vote.equalsIgnoreCase("S"))
			voteS();
		else if (vote.equalsIgnoreCase("T"))
			voteT();
		else {
			throw new IllegalArgumentException(vote + " not supported!");
		}
	}
}
