package org.platforms.user;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.platforms.MemberManager;
import org.platforms.model.Member;
import org.platforms.model.MemberContact;
import org.platforms.ws.Session;

import abaxx.core.security.SecurityContext;

public class ContactLists {
	
	public static final String KEY = ContactLists.class.getName();
		
	public static ContactLists instanceFor(HttpSession session) {
		ContactLists result =  (ContactLists) session.getAttribute(KEY);
		if (result == null) {
			Long id = SecurityContext.current().identity().getIdentifier().asLong();
			result = new ContactLists(id);
			session.setAttribute(KEY, result);
		}
		return result;
	}
	
	public static ContactLists instanceFor(Session session) {
		ContactLists result =  (ContactLists) session.getAttribute(KEY);
		if (result == null) {
			Long id = SecurityContext.current().identity().getIdentifier().asLong();
			result = new ContactLists(id);
			session.putAttribute(KEY, result);
		}
		return result;
	}

	protected Long userId;
	protected List confirmed = new ArrayList();
	protected List received = new ArrayList();
	protected List sent = new ArrayList();
	

	public ContactLists(Long userId) {
		this.userId = userId;
		if (userId != null) {
			init();
		}
	}
	
	public void init() {
		MemberManager manager = MemberManager.instance();
		confirmed = manager.getContactsToUser(userId, MemberContact.Status.IN_CONTACT);
		received = manager.getContactsToUser(userId, MemberContact.Status.RECEIVED);
		sent =  manager.getContactsToUser(userId, MemberContact.Status.SENT);
	}
	
	public Integer getStatusFor(Member member) {
		if (confirmed.contains(member)) {
			return MemberContact.Status.IN_CONTACT;
		} else if (received.contains(member)) {
			return MemberContact.Status.RECEIVED;
		} else if (sent.contains(member)) {
			return MemberContact.Status.SENT;
		} else {
			return MemberContact.Status.NO_CONTACT;
		}
	}
	
	public List getConfirmed() {
		return confirmed;
	}

	public List getReceived() {
		return received;
	}

	public List getSent() {
		return sent;
	}

	public StatusLists filterByStatus(List members) {
		StatusLists result = new StatusLists();
		for (Iterator i= members.iterator(); i.hasNext(); ) {
			Member member = (Member)i.next();
			if (confirmed.contains(member)) {
				result.getInContacts().add(member);
			} else if (received.contains(member)) {
				result.getReceived().add(member);
			} else if (sent.contains(member)) {
				result.getSent().add(member);
			} else {
				result.getNoContacts().add(member);
			}
		}
		return result;
	}

	public StatusLists asStatusLists() {
		StatusLists lists = new StatusLists();
		lists.getInContacts().addAll(confirmed);
		lists.getReceived().addAll(received);
		lists.getSent().addAll(sent);
		return lists;
	}
}
