package org.platforms.user;

import abaxx.web.control.RequestProcessor;
import abaxx.web.aspects.I18nResources;
import abaxx.basics.Log;

import java.util.*;

/**
 * Created by IntelliJ IDEA.
 * User: DKFL
 * Date: 25.01.2007
 * Time: 10:28:28
 * To change this template use File | Settings | File Templates.
 */
public class Helper {

	private static final Log.Writer LOG = Log.writerFor(Helper.class);

	public final static int[] determineSelectionOptions(final String keyPrefix, final boolean sortByIndex) {
	    return determineSelectionOptions(keyPrefix, null, sortByIndex);
	}
	
	/**
	 * Returns an array of indices of all available options for the given resource bundle and prefix.
	 * E.g. a call to a bundle containing the following entries with acadTitle.value. as prefix will return [0,1,2,3]. <p>
	 * acadTitle.value.0=<br>
	 * acadTitle.value.1=Dr.<br>
	 * acadTitle.value.2=Prof.<br>
	 * acadTitle.value.3=Prof. Dr.<br>
	 *
	 * @param keyPrefix the prefix before the indices
	 * @return
	 */
	public final static int[] determineSelectionOptions(final String keyPrefix) {
	    return determineSelectionOptions(keyPrefix, true);
	}

	/**
	 * Returns an array of indices of all available options for the given resource bundle and prefix.
	 * E.g. a call to a bundle containing the following entries with acadTitle.value. as prefix will return [0,1,2,3]. <p>
	 * acadTitle.value.0=<br>
	 * acadTitle.value.1=Dr.<br>
	 * acadTitle.value.2=Prof.<br>
	 * acadTitle.value.3=Prof. Dr.<br>
	 *
	 * @param keyPrefix the prefix before the indices
	 * @param sortByIndex sort the entries by their index not by their value
	 * @return
	 */
	public final static int[] determineSelectionOptions(final String keyPrefix, final String bundleName, final boolean sortByIndex) {

	    final ResourceBundle bundle = bundleName != null ?
	            I18nResources.instanceFor(bundleName, null, RequestProcessor.currentRequest()).getResourceBundle() :
	            I18nResources.instanceFor(RequestProcessor.currentRequest()).getResourceBundle();
	    final Enumeration keys = bundle.getKeys();
	    final HashMap allEntries = new HashMap();
	    while (keys.hasMoreElements()) {
	        final String current = (String) keys.nextElement();
	        if (current.startsWith(keyPrefix)) {
	            try {
	                final String indexValue = current.substring(keyPrefix.length());
	                final Integer index = Integer.valueOf(indexValue);
	                allEntries.put(index, bundle.getString(current));
	            } catch (Exception ex) {
	                LOG.warn("Error while determining options for " + keyPrefix +
	                        " in bundle " + bundle + ": " + ex.toString());
	            }
	        }
	    }

	    final SortedSet sorted = new TreeSet();
	    if (sortByIndex) {
	        for (Iterator iter=allEntries.keySet().iterator(); iter.hasNext(); )
	            sorted.add(iter.next());

	        final int[] result = new int[sorted.size()];
	        int i = 0;
	        for (Iterator iter = sorted.iterator(); iter.hasNext(); i++) {
	            result[i] = ((Integer) iter.next()).intValue();
	        }
	        return result;

	    } else {
	        for (Iterator iter=allEntries.keySet().iterator(); iter.hasNext(); )
	            sorted.add(allEntries.get(iter.next()));

	        final int[] result = new int[sorted.size()];
	        int i = 0;
	        for (Iterator iter=sorted.iterator(); iter.hasNext(); ) {
	            String currentValue = (String)iter.next();
	            // search fitting key for current value
	            for (Iterator inner=allEntries.keySet().iterator(); inner.hasNext(); ) {
	                Integer currentKey = (Integer)inner.next();
	                if (allEntries.get(currentKey).equals(currentValue)) {
	                    result[i++] = currentKey.intValue();
	                    break;
	                }
	            }
	        }
	        return result;
	    }
	}

}
