package org.platforms.user;

import abaxx.basics.Coerce;
import abaxx.core.security.SecurityContext;
import abaxx.web.aspects.*;
import abaxx.web.widgets.DefaultTableModel;
import abaxx.web.widgets.Table;
import org.platforms.MemberManager;
import org.platforms.chart.ChartModel;
import org.platforms.model.Member;
import org.platforms.model.MemberContact;

import javax.servlet.ServletException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: DKFL
 * Date: 25.01.2007
 * Time: 18:32:44
 * To change this template use File | Settings | File Templates.
 */
public class MemberListController implements IController, IController.Callbacks {

	private Table members;
	private int typeToDisplay;

    private String message;

    public ActionResult action(Request request, AspectModel model) throws ServletException {
		getMembers().process(request);

        message = null;

        if ("refresh".equals(request.event())) {
			return onRefresh(request);
		} else if ("refresh-by-model".equals(request.event())) {
			return onRefreshByModel(request);
		} else if ("accept".equals(request.event())) {
			return onAccept(request, model);
		} else if ("decline".equals(request.event())) {
			return onDecline(request, model);
		} else if ("request".equals(request.event())) {
			return doRequest(request, model);
		}

		return ActionResult.SUCCEEDED;
	}

	private ActionResult onAccept(Request request, AspectModel model) {
		List keys = new ArrayList();

		for (Iterator it = members.getSelection().iterator(); it.hasNext();) {
			Member member = (Member) it.next();
			keys.add(member.getId());
		}

		if (keys.size() > 0) {
			MemberManager.instance().requestContact(
					SecurityContext.current().identity().getIdentifier().asLong(),
					keys,
					true);

            ContactLists.instanceFor(request.getSession()).init();
        }

        this.message = "Accepted " + keys.size() + " requests sucessfully!";

        return onRefresh(request);
	}

	private ActionResult onDecline(Request request, AspectModel model) {
		List keys = new ArrayList();

		for (Iterator it = members.getSelection().iterator(); it.hasNext();) {
			Member member = (Member) it.next();
			keys.add(member.getId());
		}

		if (keys.size() > 0) {
			MemberManager.instance().requestContact(
					SecurityContext.current().identity().getIdentifier().asLong(),
					keys,
					false);

            ContactLists.instanceFor(request.getSession()).init();
        }

        this.message = "Declined " + keys.size() + " requests sucessfully!";

        return onRefresh(request);
	}

	private ActionResult doRequest(Request request, AspectModel aspectModel) {

		List keys = new ArrayList();

        ContactLists contactLists = ContactLists.instanceFor(request.getSession());
        //refresh
        contactLists.init();

        for (Iterator it = getMembers().getSelection().iterator(); it.hasNext();) {
			Member member = (Member) it.next();

            Integer status = contactLists.getStatusFor(member);

            if (status == MemberContact.Status.IN_CONTACT  ) {
                aspectModel.errors().add(null, member.getUsername() + " already in status CONTACT");
                return ActionResult.FAILED;
            } else if (status == MemberContact.Status.RECEIVED  ) {
                aspectModel.errors().add(null, member.getUsername() + " already in status RCD_Received");
                return ActionResult.FAILED;
            } else if (status == MemberContact.Status.SENT  ) {
                aspectModel.errors().add(null, member.getUsername() + " already in status RCD_Sent");
                return ActionResult.FAILED;
            }

            keys.add(member.getId());
		}

        if (keys.size() > 0) {
			MemberManager.instance().requestContact(
					SecurityContext.current().identity().getIdentifier().asLong(),
					keys,
					true);

            contactLists.init();
        }

        this.message = "Sent " + keys.size() + " requests sucessfully!";

        return ActionResult.SUCCEEDED;

	}

	private ActionResult onRefreshByModel(Request request) {
		MemberListModel m = (MemberListModel) request.getRequest().getAttribute("model");
		if (m != null) {
			typeToDisplay = 0;
			AspectModel.set(m, request);
			getMembers().setModel(new DefaultTableModel(m.getToDisplay()));
		} else {
			m = AspectModel.get(request) != null ? (MemberListModel) AspectModel.get(request) : new MemberListModel(new ArrayList());
			getMembers().setModel(new DefaultTableModel());
		}
		return onRefreshChart(request, m);
	}

	private ActionResult onRefresh(Request request) {
		MemberListModel m = new MemberListModel(typeToDisplay);
		AspectModel.set(m, request);
		getMembers().setModel(new DefaultTableModel(m.getToDisplay()));
		return onRefreshChart(request, m);
	}

	private ActionResult onRefreshChart(Request request, MemberListModel list) {
		ChartModel m = new ChartModel();
		m.setStatusLists(ContactLists.instanceFor(request.getSession()).filterByStatus(list.getToDisplay()));
		request.getRequest().setAttribute("chartModel", m);
		return ActionResult.forwardTo("chart", "draw");
	}

	public Table getMembers() {
		if (members == null)
			members = new Table(new DefaultTableModel());
		return members;
	}

	public int getTypeToDisplay() {
		return typeToDisplay;
	}

	public void onInitialize(Request request) throws ServletException {
		typeToDisplay = Coerce.toInt(request.delegate().getInitProperties().get("typeToDisplay"), MemberContact.Status.IN_CONTACT2);
		onRefresh(request);
	}

	public void onDisplay(Request request) throws ServletException {

	}

	public boolean isAcceptable() {
		return (MemberContact.Status.RECEIVED.intValue() == this.typeToDisplay) && (! members.isEmpty());
	}

	public boolean isSearchResult() {
		return this.typeToDisplay == 0;
	}

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

}

