package org.platforms.user;

import abaxx.core.foundation.ConstraintException;
import abaxx.core.users.UserAccount;
import abaxx.core.users.UserRegistry;
import abaxx.web.ajax.AjaxAutocompletionResponse;
import abaxx.web.aspects.*;
import abaxx.web.control.ScopedModel;
import abaxx.web.parts.CompositePart;
import abaxx.web.parts.SwitchLayout;
import abaxx.web.parts.VisualPart;
import abaxx.web.events.EventsRegistry;
import abaxx.web.events.LoginEvent;

import javax.servlet.ServletException;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.platforms.MemberManager;
import org.platforms.model.Member;
import org.platforms.model.Preference;

/**
 * Created by IntelliJ IDEA.
 * User: DKFL
 * Date: 25.01.2007
 * Time: 10:09:13
 * To change this template use File | Settings | File Templates.
 */
public class UserController implements IController, IController.Callbacks {

	public ActionResult action(final Request request, final AspectModel model) {
		final String eve = request.event();
		if ("save".equals(eve) || "update".equals(eve))
			return onSave(request, model);
		if ("reload".equals(eve))
			return onReload(request);
		if ("update-mbti".equals(eve))
			return onUpdateMbti(request, model);
		if ("more-likes".equals(eve))
			return onMoreLikes(request, model);
		if ("more-dislikes".equals(eve))
			return onMoreDislikes(request, model);
		if ("autocomplete".equals(eve))
			return onAutoComplete(request, model);
		return null;
	}

	public ActionResult onAutoComplete(Request request, AspectModel model) {
		String pattern = request.getParameter("pattern");
		if (pattern == null || "".equals(pattern)) {
			return ActionResult.ABORT;
		}
		pattern += "%";
		List  ps = MemberManager.instance().getLikesName(pattern);
		HashMap autoCompletionValues = new HashMap();
		for (Iterator i = ps.iterator(); i.hasNext();) {
			Preference p = (Preference)i.next();
			autoCompletionValues.put(p.getValue(), p.getValue());
		}
		AjaxAutocompletionResponse autoResponse = new AjaxAutocompletionResponse(request.getResponse());
		return autoResponse.send(autoCompletionValues);
	}

	private ActionResult onUpdateMbti(Request request, AspectModel model) {
		final UserModel user = (UserModel) model.get(false);
		user.setTestResult(request.getParameter("tttResult"));
		return onSave(request, model);
	}

	private ActionResult onReload(Request request) {
		UserAccount loggedIn = UserRegistry.currentUser();
		if (loggedIn == null)
			AspectModel.set(new UserModel(), request); // registration
		else
			AspectModel.set(new UserModel(loggedIn), request); // profile update
		return ActionResult.SUCCEEDED;
	}

	public ActionResult onSwitchTab(final Request request, final AspectModel model) {
		model.populate();
		if (model.hasErrors())
			return propagateErrors(request, model);
		else
			return ActionResult.forwardTo(request.getParameter("targetpart"));
	}

	/**
	 * for tabbed pane where outer form gets the request and the errors which must be propagated to tab content
	 */
	public ActionResult propagateErrors(Request request, AspectModel model) {
		IView view = request.delegate();
		if (view instanceof CompositePart) {
			VisualPart child = ((SwitchLayout) ((CompositePart) view).getLayout()).getActiveComponent();
			if (child != null) {
				ScopedModel.instanceFor(child, request).setErrors(model.errors());
			}
		}
		return ActionResult.FAILED;
	}

	public ActionResult onSave(final Request request, final AspectModel model) {
		onApply(request, model);
		if (model.hasErrors())
			return ActionResult.FAILED;
		//if (model.hasErrors()) {
		//	return propagateErrors(request, model);
		//}

		final UserModel user = (UserModel) model.get(); // populate the user
		if (user.getId() == null && !userOrGroupNameisUnique(user.getName(), UserAccount.Type.USER)) {
			model.errors().add("name", new AspectError("userexists.error", user.getName()));
			return propagateErrors(request, model);
		} else {
			if (!user.checkNameIsUnique()) {
				model.errors().add("name", new AspectError("userexists.error", user.getName()));
				return propagateErrors(request, model);
			}
		}
		try {
			user.store();
			if (UserRegistry.currentUser() == null) {
				return ActionResult.forwardTo("Welcome.index.login-status", "login").
						addParam("j_username", user.getName()).addParam("j_password", user.getPassword());
			}
			return ActionResult.event().addParams("id=" + user.getId());
		} catch (ConstraintException er) {
			model.errors().add("name", new AspectError("userexists.error", user.getName()));
			return propagateErrors(request, model);
		} catch (Exception er) {
			model.errors().add(null, "userstorefailed.error", new Object[]{er.getMessage()});
			return propagateErrors(request, model);
		}
	}

	public static boolean userOrGroupNameisUnique(final String name, int type) {
		final UserRegistry reg = UserRegistry.getInstance();
		final UserAccount existing = reg.lookupAccount(name, type);
		return (existing == null);
	}

	public void onInitialize(Request request) throws ServletException {
		//To change body of implemented methods use File | Settings | File Templates.
	}

	public void onDisplay(Request request) throws ServletException {
		if (AspectModel.get(request) == null) {
			onReload(request);
		}
	}

	public ActionResult onMoreLikes(Request request, AspectModel model) {
		onApply(request, model);
		UserModel m = (UserModel) model.get();
		m.getLikes().add(new String());
		return null;
	}

	public ActionResult onMoreDislikes(Request request, AspectModel model) {
		onApply(request, model);
		UserModel m = (UserModel) model.get();
		m.getDislikes().add(new String());
		return null;
	}

	private static class Params implements IModel.Params {
		public String[] values;

		public boolean isEmpty() {
			return values == null || values.length == 0;
		}
	}

	public ActionResult onApply(Request request, AspectModel model) {
		UserModel m = (UserModel) model.get(true);

		Params input1 = new Params();
		Aspects.populate(input1, "$likes-", request, true, model.errors());
		if (input1.isEmpty())
			m.setLikes(new ArrayList());
		else
			m.setLikes(new ArrayList(Arrays.asList(input1.values)));

		Params input2 = new Params();
		Aspects.populate(input2, "$dislikes-", request, true, model.errors());
		if (input2.isEmpty())
			m.setDislikes(new ArrayList());
		else
			m.setDislikes(new ArrayList(Arrays.asList(input2.values)));

		return ActionResult.SUCCEEDED;
	}

}
