package org.platforms.user;

import java.util.ArrayList;
import java.util.List;

import abaxx.web.aspects.*;
import abaxx.core.users.UserAccount;
import abaxx.core.users.UserRegistry;
import abaxx.core.foundation.PrimaryKey;

import javax.servlet.ServletException;

import org.platforms.model.Member;
import org.platforms.model.MemberContact;
import org.platforms.MemberManager;

/**
 * Created by IntelliJ IDEA.
 * User: DKFL
 * Date: 26.01.2007
 * Time: 09:14:34
 * To change this template use File | Settings | File Templates.
 */
public class UserDisplayController implements IController {

	private boolean hasContact;

	public ActionResult action(Request request, AspectModel model) throws ServletException {
		if ("pick".equals(request.event())) {
			return onPick(request, model);
		}
		return ActionResult.SUCCEEDED;
	}

	private ActionResult onPick(Request request, AspectModel model) {
		String id = request.getParameter("id");
		if (id != null) {
			try {
				Long idLong = new Long(id);
				UserAccount user = UserRegistry.getInstance().lookupAccount(new PrimaryKey(idLong), UserAccount.Type.USER);
				if (user != null) {
					model.set(new UserModel(user));
					Member member = (Member) MemberManager.instance().getWithId(Member.class, idLong);
					if (member != null) {
						hasContact = ContactLists.instanceFor(request.getSession()).getStatusFor(member).equals(MemberContact.Status.IN_CONTACT);
					}
					List contacts = MemberManager.instance().getContactsToUser(user.getIdentifier().asLong(), MemberContact.Status.IN_CONTACT);
					//contacts = new ArrayList(contacts);
					//contacts.add(member);
					MemberListModel mlm = new MemberListModel(contacts);
					request.getRequest().setAttribute("model", mlm);
				}
			} catch(NumberFormatException ex) {
				return ActionResult.FAILED;
			}
		}
		return ActionResult.SUCCEEDED;
	}

	public boolean getHasContact() {
		return hasContact;
	}
}
