package org.platforms.user;

import abaxx.core.foundation.PrimaryKey;
import abaxx.core.users.UserAccount;
import abaxx.core.users.UserRegistry;
import abaxx.web.aspects.*;
import abaxx.web.aspects.converters.StandardConverter;
import abaxx.web.control.RequestProcessor;
import org.platforms.MemberManager;
import org.platforms.gps.GpsConverter;
import org.platforms.model.Member;
import org.platforms.ttt.TttResult;

import javax.servlet.ServletRequest;
import java.util.*;

/**
 * Created by IntelliJ IDEA.
 * User: DKFL
 * Date: 25.01.2007
 * Time: 09:52:10
 * To change this template use File | Settings | File Templates.
 */
public class UserModel implements IModel.Info, IModel.Callbacks {

	private PrimaryKey id;

	// default values
	private String name, password, repeatPassword;
	private String firstname, lastname;
	private int courtesyTitle;
	private Date birth;

	// contact values
	private String email;
	// address values
	private String town;
	private String country = "Germany";
	private String gps;

	// type values
	private String primaryMotto, secondaryMotto;
	private int primaryEnneagram, secondaryEnneagram;
	private List likes, dislikes;

	private Date registeredDate;

	// test data
	private String tttResult;
	private String mbtiType;
	private Date tttDate;

	public Aspects getAspects() {
		final Aspects aspects = new Aspects(this.getClass());

		// general info
		aspects.at("name").beMandatory().setMaxLength(77);
		aspects.at("firstname").beMandatory().setMaxLength(77);
		aspects.at("lastname").beMandatory().setMaxLength(77);
		aspects.at("birth").setConverter(new StandardConverter.ForDate());

		// password
		aspects.at("password").setMaxLength(77);
		aspects.at("repeatPassword").setMaxLength(77);

		// contact info
		aspects.at("email").beMandatory().addValidator(new EmailValidator()).setMaxLength(77);

		// address info
		aspects.at("town").beMandatory().setMaxLength(77);
		aspects.at("country").beMandatory().setMaxLength(77);

		aspects.at("primaryMotto").beMandatory().setMaxLength(255);
		aspects.at("secondaryMotto").setMaxLength(255);

		aspects.at("gps").addValidator(new GpsValidator());
		return aspects;
	}


	/**
	 * checks if a possibly new name of a user is unique
	 */
	public boolean checkNameIsUnique() {
		if (id == null)
			return true; // the user is not saved yet
		UserRegistry reg = UserRegistry.getInstance();
		UserAccount lookup = reg.lookupAccount(id, UserAccount.Type.USER);
		if (lookup.getName().equals(this.name)) {
			return true; // the name has not been modified
		} else {
			return (reg.lookupAccount(this.name, UserAccount.Type.USER) == null);
		}
	}

	public UserModel() {

	}

	public UserModel(UserAccount account) {
		id = account.getIdentifier();
		name = account.getName();

		Member memberData = (Member) MemberManager.instance().getWithId(Member.class.getName(), new Long(id.getId()));
		String full = memberData.getFullname();
		firstname = full.substring(0, full.indexOf(" "));
		lastname = full.substring(full.indexOf(" ") + 1, full.length());
		email = memberData.getEmailAddress();
		gps = memberData.getGpsCoordinates();
		town = memberData.getTown();
		country = memberData.getCountry();
		primaryMotto = memberData.getMotto1();
		secondaryMotto = memberData.getMotto2();
		primaryEnneagram = memberData.getEnneagramtype1();
		secondaryEnneagram = memberData.getEnneagramtype2();
		mbtiType = memberData.getMbtiType();
		tttResult = memberData.getTttResult();
		tttDate = memberData.getTttDate();

		likes = memberData.getLikes();
		dislikes = memberData.getDislikes();
		registeredDate = memberData.getRegistrationDate();
	}

	public void store() {
		final UserRegistry reg = UserRegistry.getInstance();
		final UserAccount toStore;
		if (id != null) {
			toStore = reg.lookupAccount(id, UserAccount.Type.USER);
		} else {
			toStore = reg.prepareUser();
		}
		toStore.setName(name);
		toStore.setDisplayName(firstname + " " + lastname);
		toStore.setStatus(UserAccount.Status.ENABLED);

		if (password != null)
			toStore.setPassword(password);

		reg.store(toStore);
		if (id == null)
			registeredDate = new Date();

		Member memberData = new Member();
        memberData.setLikesLoaded(true); //important!!

        if (id== null) {
            memberData.setLastVisitDate(new Date());
        }

        memberData.setId(new Long(toStore.getIdentifier().getId()));
		memberData.setUsername(name);
		memberData.setFullname(firstname + " " + lastname);
		memberData.setEmailAddress(email);

		memberData.setGpsCoordinates(gps);
		memberData.setTown(town);
		memberData.setCountry(country);
		memberData.setMotto1(primaryMotto);
		memberData.setMotto2(secondaryMotto);
		memberData.setEnneagramtype1(primaryEnneagram);
		memberData.setEnneagramtype2(secondaryEnneagram);

		memberData.setMbtiType(mbtiType);
		memberData.setTttResult(tttResult);
		memberData.setTttDate(tttDate);

		memberData.setLikes(likes);
		memberData.setDislikes(dislikes);
		memberData.setRegistrationDate(registeredDate);

		if (id == null) {
			MemberManager.instance().create(memberData);
		} else {
			MemberManager.instance().store(memberData);
		}
		id = toStore.getIdentifier();
	}

	public Date getBirth() {
		return birth;
	}

	public void setBirth(Date birth) {
		this.birth = birth;
	}

	public int getCourtesyTitle() {
		return courtesyTitle;
	}

	public void setCourtesyTitle(int courtesyTitle) {
		this.courtesyTitle = courtesyTitle;
	}

	public List getDislikes() {
		return dislikes;
	}

	public void setDislikes(List dislikes) {
		this.dislikes = dislikes;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getFirstname() {
		return firstname;
	}

	public void setFirstname(String firstname) {
		this.firstname = firstname;
	}

	public String getGps() {
		return gps;
	}

	public void setGps(String gps) {
		this.gps = gps;
	}

	public PrimaryKey getId() {
		return id;
	}

	public void setId(PrimaryKey id) {
		this.id = id;
	}

	public String getLastname() {
		return lastname;
	}

	public void setLastname(String lastname) {
		this.lastname = lastname;
	}

	public List getLikes() {
		return likes;
	}

	public void setLikes(List likes) {
		this.likes = likes;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public int getPrimaryEnneagram() {
		return primaryEnneagram;
	}

	public void setPrimaryEnneagram(int primaryEnneagram) {
		this.primaryEnneagram = primaryEnneagram;
	}

	public String getPrimaryMotto() {
		return primaryMotto;
	}

	public void setPrimaryMotto(String primaryMotto) {
		this.primaryMotto = primaryMotto;
	}

	public Date getRegisteredDate() {
		return registeredDate;
	}

	public void setRegisteredDate(Date registeredDate) {
		this.registeredDate = registeredDate;
	}

	public String getRepeatPassword() {
		return repeatPassword;
	}

	public void setRepeatPassword(String repeatPassword) {
		this.repeatPassword = repeatPassword;
	}

	public int getSecondaryEnneagram() {
		return secondaryEnneagram;
	}

	public void setSecondaryEnneagram(int secondaryEnneagram) {
		this.secondaryEnneagram = secondaryEnneagram;
	}

	public String getSecondaryMotto() {
		return secondaryMotto;
	}

	public void setSecondaryMotto(String secondaryMotto) {
		this.secondaryMotto = secondaryMotto;
	}

	public String getTown() {
		return town;
	}

	public void setTown(String town) {
		this.town = town;
	}

	public void reset(ServletRequest servletRequest) {
		//To change body of implemented methods use File | Settings | File Templates.
	}

	public void validate(ServletRequest servletRequest, AspectErrors errors) {
		if (id == null && (password == null || password.trim().equals(""))) {
			// check empty password for new user
			errors.add("password", "emptyPassword.error", new Object[]{});
		}
		if (password != null && !password.equals(repeatPassword)) {
			errors.add("repeatPassword", "repeatPassword.error", new Object[]{});
		}
		//if (courtesyTitle == 0)
		//	errors.add("courtesyTitle", "errors.mandatory");
		//if (primaryEnneagram == 0)
		//	errors.add("primaryEnneagram", "errors.mandatory");
	}

	public String[] getCountryoptions() {
		final ResourceBundle bundle = I18nResources.instanceFor("org.platforms.user.User", null, RequestProcessor.currentRequest()).getResourceBundle();
		final Enumeration keys = bundle.getKeys();
		final List allEntries = new ArrayList();
		while (keys.hasMoreElements()) {
			final String current = (String) keys.nextElement();
			if (current.startsWith("country.value.")) {
				allEntries.add(bundle.getString(current));
			}
		}
		Collections.sort(allEntries);
		return (String[]) allEntries.toArray(new String[]{});
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public void setTestResult(String result) {
		TttResult r = new TttResult(result, true);
		setMbtiType(r.getMbtiResult());
		setTttResult(r.getNormalizedResult());
		setTttDate(new Date());
	}

	public String getMbtiType() {
		return mbtiType;
	}

	public String getKeirseyType() {
		if (tttResult == null) return null;
		return new TttResult(tttResult, true).getKeirseyResult();
	}

	public String getKeirseyTypeLink() {
		if (tttResult == null) return null;
		return new TttResult(tttResult, true).getKeirseyResult().toLowerCase();
	}

	public void setMbtiType(String mbtiType) {
		this.mbtiType = mbtiType;
	}

	public Date getTttDate() {
		return tttDate;
	}

	public void setTttDate(Date tttDate) {
		this.tttDate = tttDate;
	}

	public String getTttResult() {
		return tttResult;
	}

	public void setTttResult(String tttResult) {
		this.tttResult = tttResult;
	}

	public double getGpslong() {
		return (gps != null) ? GpsConverter.getLongitude(gps) : 0;
	}

	public double getGpslat() {
		return (gps != null) ? GpsConverter.getLatitude(gps) : 0;
	}
}
