package org.platforms.ws;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


public class Session {
	String id;
	long lastUsed;
	Map attributes = Collections.synchronizedMap(new HashMap());
	
	public Session(String id, long lastUsed) {
		this.id = id;
		this.lastUsed = lastUsed;
	}

	public void touch() {
		lastUsed = System.currentTimeMillis();
	}
	
	public String getId() {
		return id;
	}
	
	public Object getAttribute(String name) {
		return attributes.get(name);
	}
	
	public Object  putAttribute(String name, Object value) {
		return attributes.put(name, value);
	}
	
	public Object removeAttribute(String name) {
		return attributes.remove(name);
	}

	public long getLastUsed() {
		return lastUsed;
	}
	
}
