package org.platforms.ws;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

import abaxx.core.foundation.Cache;
import abaxx.core.foundation.Trace;
/*
 * Stores the sessions objects for web services
 */
public class SessionStore {
	
	static Map sessions = Collections.synchronizedMap(new HashMap());
	static {
		final Timer timer = new Timer();
		TimerTask task = new TimerTask() {

			public void run() {
				try {
					SessionStore.cleanup();
				} catch (Throwable t) {
					timer.cancel();
				}
			}
			
		};
		timer.scheduleAtFixedRate(task, 1000, 60000);
		
	}
	
	public static synchronized Session createSession() {
		
		long created = System.currentTimeMillis();
		String key = ""+ Math.random() + ":" + created; 
		Session session = new Session(key, created);
		sessions.put(key, session);
		return session;
	}
	
	public static synchronized Session getSession(String id) {
		Session result = (Session) sessions.get(id);
		if (result != null) {
			result.touch();
		}
		return result;
	}
	
	public static synchronized void closeSession(String id) {
		sessions.remove(id);
	}
	
	public static synchronized void cleanup() {
		// timestamp one hour ago
		long timeout = System.currentTimeMillis() - 3600000;
		//long timeout = System.currentTimeMillis() - 300000;
		for (Iterator i = sessions.entrySet().iterator(); i.hasNext(); ) {
			Map.Entry entry = (Map.Entry)i.next();
			Session session = (Session)entry.getValue();
			if (session.getLastUsed() < timeout) {
				System.out.println(" *** Session " + session.getId() + " timed out ***");
				Trace.debug("Removing Session " + session.getId(), SessionStore.class);
				i.remove();
			}
		}
	}
	
}
