/**
 * SoapSoapBindingImpl.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.2.1 Jun 14, 2005 (09:15:57 EDT) WSDL2Java emitter.
 */

package org.platforms.ws;


import java.security.Principal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

import org.platforms.MemberManager;
import org.platforms.chart.ChartController;
import org.platforms.chart.ChartModel;
import org.platforms.model.Member;
import org.platforms.model.MemberContact;
import org.platforms.search.ui.SearchController;
import org.platforms.search.ui.SearchModel;
import org.platforms.ttt.TttResult;
import org.platforms.user.ContactLists;
import org.platforms.user.StatusLists;
import org.platforms.user.UserModel;

import ChartDirector.XYChart;
import abaxx.basics.Reflector;
import abaxx.core.foundation.ClientSession;
import abaxx.core.foundation.Trace;
import abaxx.core.security.IdentificationLevel;
import abaxx.core.security.Identity;
import abaxx.core.security.LoginFailedException;
import abaxx.core.security.SecurityContext;
import abaxx.core.security.SecurityPolicy;
import abaxx.core.users.UserAccount;
import abaxx.web.aspects.AspectErrors;
import abaxx.web.aspects.AspectModel;
import abaxx.web.aspects.Aspects;
import abaxx.web.aspects.SelectionInList;
import abaxx.web.parts.internal.AbstractAspect;

public class SoapSoapBindingImpl implements org.platforms.ws.PbTServices{

	private static final String ABAXX_SECURITY_CONTEXT = "abaxx.security.context";

	public void clearDatabase() throws java.rmi.RemoteException {
		MemberManager.instance().clearDatabase();
    }

	public static class WSSecurityContext extends SecurityContext {
		public static Identity login (final String name, Object credential) throws LoginFailedException
		{
			securityPolicy.login (name, credential);
			securityPolicy.setupPrincipalPropagation (name, credential);
			return WSSecurityContext.setup (
				new Principal() { public String getName() { return name; }}, 
				IdentificationLevel.LOGIN 
			) .identity();
		}
		
		public static SecurityContext  setup (Principal p, IdentificationLevel level) {
			SecurityContext context = securityPolicy.contextFor(p,level);
			setCurrent(context);
			return context;
		}	
		
		public static void setCurrent(SecurityContext context) {
			current.set(context);
		}
		
	}
	
    public java.lang.String login(java.lang.String username, java.lang.String password) throws java.rmi.RemoteException {
		try {
			
    		WSSecurityContext.login(username, password);
    		SecurityContext context =  SecurityContext.current();
    		
    		Session session =  SessionStore.createSession();
    		session.putAttribute(ABAXX_SECURITY_CONTEXT, context);
    		return session.getId();
    		
    	} catch (LoginFailedException e) {
    		Trace.error(e, this);
    		return null;
    	} catch (RuntimeException e) {
    		Trace.error(e, this);
    		throw e;
    	} finally {
    		SecurityContext.reset();
    	}
    }

    public void logout(java.lang.String sessionId) throws java.rmi.RemoteException {
    	SessionStore.closeSession(sessionId);
    }

    public java.lang.String takeTtt(java.lang.String sessionId, java.lang.String answers) throws java.rmi.RemoteException {
    	Session session = SessionStore.getSession(sessionId);
    	if (session == null) {
    		return null;
    	}
    	try {
    		SecurityContext securityContext = (SecurityContext) session.getAttribute(ABAXX_SECURITY_CONTEXT);
    		if (securityContext == null) {
    			return null;
    		}
    		WSSecurityContext.setCurrent(securityContext);
    		
    		TttResult result = new TttResult(answers, false);
    		UserAccount account = (UserAccount) SecurityContext.current().identity();
    		MemberManager manager = MemberManager.instance();
    		Member member = (Member) manager.getWithId(Member.class,  account.getIdentifier().asLong());
    		member.setTttDate(new Date());
    		member.setTttResult(result.getNormalizedResult());
    		member.setMbtiType(result.getMbtiResult());
    		manager.store(member);

    		return result.getNormalizedResult();
    	} catch (RuntimeException e) {
    		Trace.error(e, this);
    		throw e;
    	} finally {

    		SecurityContext.reset();
    	}
    }
	
	public org.platforms.ws.Memberinfo getMemberinfo(java.lang.String sessionId, java.lang.String username) throws java.rmi.RemoteException {
    	Session session = SessionStore.getSession(sessionId);
    	if (session == null) {
    		return null;
    	}
    	try {
    		SecurityContext securityContext = (SecurityContext) session.getAttribute(ABAXX_SECURITY_CONTEXT);
    		if (securityContext == null) {
    			return null;
    		}
    		WSSecurityContext.setCurrent(securityContext);
    		
    		MemberManager manager = MemberManager.instance();
    		Member member = manager.getMemberByName(username);
    		if (member == null) {
    			Trace.error("Member with name " + username + " not found!", this);
    			return null;
    		}
    		return createMemberInfo(member);
    	} catch (RuntimeException e) {
    		Trace.error(e, this);
    		throw e;
    	} finally {

    		SecurityContext.reset();
    	}
    }

    public org.platforms.ws.Memberinfo[] getMemberlist(java.lang.String sessionId, java.lang.String username, java.lang.String rcdStatus) throws java.rmi.RemoteException {
    	Session session = SessionStore.getSession(sessionId);
    	if (session == null) {
    		return null;
    	}
    	try {
    		SecurityContext securityContext = (SecurityContext) session.getAttribute(ABAXX_SECURITY_CONTEXT);
    		if (securityContext == null) {
    			return null;
    		}
    		WSSecurityContext.setCurrent(securityContext);
    		UserAccount account = (UserAccount) securityContext.identity();
    		Integer status = MemberContact.Status.fromString(rcdStatus);
    		if (!username.equals(account.getName()) && !MemberContact.Status.IN_CONTACT.equals(status)) {
    			return null;
    		}
    		
    		MemberManager manager = MemberManager.instance();
    		if (status == null) {
    			return null;
    		}
    		
    		List members = manager.getContactsToUser(account.getIdentifier().asLong(), status);
    		
    		if (members == null) {
    			Trace.error("Members for name " + username + " and status " + status + "  not found!", this);
    			return null;
    		}
    		Memberinfo[] result = new Memberinfo[members.size()];
    		for (int i = 0; i<result.length; i++) {
    			result[i] = createMemberInfo((Member) members.get(i));
    		}
    		return result;
    	} catch (RuntimeException e) {
    		Trace.error(e, this);
    		throw e;
    	} finally {

    		SecurityContext.reset();
    	}
    }

	private Memberinfo createMemberInfo(Member member) {
		Memberinfo memberinfo = new Memberinfo();
		memberinfo.setUsername(member.getUsername());
		memberinfo.setCountry(member.getCountry());
		memberinfo.setDislikes(member.getDislikes() == null ? null : (String[]) member.getDislikes().toArray(new String[0]));
		memberinfo.setLikes(member.getLikes() == null ? null : (String[]) member.getLikes().toArray(new String[0]));
		memberinfo.setEmailAddress(member.getEmailAddress());
		memberinfo.setEnneagramtype1(member.getEnneagramtype1());
		memberinfo.setEnneagramtype2(member.getEnneagramtype2());
		memberinfo.setFullname(member.getFullname());
		memberinfo.setGpsCoordinates(member.getGpsCoordinates());
		memberinfo.setMotto1(member.getMotto1());
		memberinfo.setMotto2(member.getMotto2());
		Calendar calendar = new GregorianCalendar();
		calendar.setTime(member.getRegistrationDate());
		memberinfo.setRegistrationTime(calendar);
		memberinfo.setTown(member.getTown());
		calendar.setTime(member.getTttDate());
		memberinfo.setTttTestTime(calendar);
		memberinfo.setTttType(member.getMbtiType());
		return memberinfo;
	}

    public byte[] getMemberlistGraphic(java.lang.String sessionId, int xSize, int ySize, java.lang.String xVariable, java.lang.String yVariable, java.lang.String username, java.lang.String rcdStatus) throws java.rmi.RemoteException {
    	Session session = SessionStore.getSession(sessionId);
    	if (session == null) {
    		return null;
    	}
    	try {
    		SecurityContext securityContext = (SecurityContext) session.getAttribute(ABAXX_SECURITY_CONTEXT);
    		if (securityContext == null) {
    			return null;
    		}
    		WSSecurityContext.setCurrent(securityContext);
    		UserAccount account = (UserAccount) securityContext.identity();
    		Integer status = MemberContact.Status.fromString(rcdStatus);
    		if (!username.equals(account.getName()) && !MemberContact.Status.IN_CONTACT.equals(status)) {
    			return null;
    		}
    		
    		ChartModel chartModel = new ChartModel();
    		
    		chartModel.setxAxis(xVariable);
    		chartModel.setyAxis(yVariable);
    		ChartController cc = new ChartController();
    		XYChart chart =  cc.createOverviewChart(chartModel, xSize, ySize);
    		return chart.makeChart(0);
    	} catch (RuntimeException e) {
    		Trace.error(e, this);
    		throw e;
    	} finally {

    		SecurityContext.reset();
    	}    
    }

    private void setIfNotNull(SelectionInList sil, int value) {
    	if (value != 0) {
    		sil.setSelection(new Integer(value));
    	}
    }
    
    public org.platforms.ws.Memberinfo[] searchForMembers(java.lang.String sessionId, boolean noContact, boolean noRcdSent, boolean newlyRegistered, int newlyRegisteredSinceDays, 
    		boolean inMyCountry, int maxKilometersAway, java.lang.String[] tttTypes, boolean myEnneagramType1, boolean myEnneagramType, 
    		boolean relatedEnneagramType, java.lang.String mottoContains, 
    		int minLikesShared, int minDislikesShared, int maxLikesDisliked, int maxDislikesLiked) throws java.rmi.RemoteException {
    	Session session = SessionStore.getSession(sessionId);
    	if (session == null) {
    		return null;
    	}
    	try {
    		SecurityContext securityContext = (SecurityContext) session.getAttribute(ABAXX_SECURITY_CONTEXT);
    		if (securityContext == null) {
    			return null;
    		}
    		WSSecurityContext.setCurrent(securityContext);

            Long me = securityContext.identity().getIdentifier().asLong();

            List members = search( me,noContact, noRcdSent, newlyRegistered, newlyRegisteredSinceDays, inMyCountry, maxKilometersAway, tttTypes, myEnneagramType1, myEnneagramType, relatedEnneagramType, mottoContains, minLikesShared, minDislikesShared, maxLikesDisliked, maxDislikesLiked);
    		Memberinfo[] result = new Memberinfo[members.size()];
    		for (int i = 0; i<result.length; i++) {
    			result[i] = createMemberInfo((Member) members.get(i));
    		}
    		return result;

    	} catch (RuntimeException e) {
    		Trace.error(e, this);
    		return null;
    	} finally {
    		SecurityContext.reset();
    	}   
    }
    public byte[] searchForMembersGraphic(java.lang.String sessionId, int xSize, int ySize, java.lang.String xVariable, java.lang.String yVariable, boolean noContact, boolean noRcdSent, boolean newlyRegistered, int newlyRegisteredSinceDays, boolean inMyCountry, int maxKilometersAway, java.lang.String[] tttTypes, boolean myEnneagramType1, boolean myEnneagramType, boolean relatedEnneagramType, java.lang.String mottoContains, int minLikesShared, int minDislikesShared, int maxLikesDisliked, int maxDislikesLiked) throws java.rmi.RemoteException {
    	Session session = SessionStore.getSession(sessionId);
    	if (session == null) {
    		return null;
    	}
    	try {
    		SecurityContext securityContext = (SecurityContext) session.getAttribute(ABAXX_SECURITY_CONTEXT);
    		if (securityContext == null) {
    			return null;
    		}
    		WSSecurityContext.setCurrent(securityContext);

	            Long me = securityContext.identity().getIdentifier().asLong();

    		List members = search(me, noContact, noRcdSent, newlyRegistered, newlyRegisteredSinceDays, inMyCountry, maxKilometersAway, tttTypes, myEnneagramType1, myEnneagramType, relatedEnneagramType, mottoContains, minLikesShared, minDislikesShared, maxLikesDisliked, maxDislikesLiked);
    		
    		ContactLists contactLists = ContactLists.instanceFor(session);
    		StatusLists statusLists = contactLists.filterByStatus(members);
    		
    		ChartModel chartModel = new ChartModel();
    		
    		chartModel.setxAxis(xVariable);
    		chartModel.setyAxis(yVariable);
    		chartModel.setStatusLists(statusLists);
    		ChartController cc = new ChartController();
    		XYChart chart =  cc.createChart(chartModel, xSize, ySize);
    		return chart.makeChart(0);
    		
    	} catch (RuntimeException e) {
    		Trace.error(e, this);
    		return null;
    	} finally {
    		SecurityContext.reset();
    	}   
    }

    public void sendRcd(java.lang.String sessionId, java.lang.String[] usernames, boolean positive) throws java.rmi.RemoteException {
    	Session session = SessionStore.getSession(sessionId);
    	if (session == null) {
    		return;
    	}
    	try {
    		SecurityContext securityContext = (SecurityContext) session.getAttribute(ABAXX_SECURITY_CONTEXT);
    		if (securityContext == null) {
    			return;
    		}
    		WSSecurityContext.setCurrent(securityContext);
    		UserAccount account = (UserAccount) securityContext.identity();

    		MemberManager manager = MemberManager.instance();
    		
    		manager.requestContactWithUsernames(account.getIdentifier().asLong(), Arrays.asList(usernames), positive);
    		
    	} catch (RuntimeException e) {
    		Trace.error(e, this);
    		throw e;
    	} finally {

    		SecurityContext.reset();
    	}    
    }

    public void submitMemberinfo(java.lang.String sessionId, java.lang.String username, java.lang.String password, java.lang.String fullname, 
    		java.lang.String emailAddress, java.lang.String town, java.lang.String country, java.lang.String motto1, java.lang.String motto2,
java.lang.String[] likes, java.lang.String[] dislikes, java.lang.String gpsCoordinates, int enneagramtype1, int enneagramtype2) throws java.rmi.RemoteException {
    	if (sessionId == null) {
    		// register user
    		UserModel userModel = new UserModel();
    		userModel.setName(username);
    		fillUserModel(password, fullname, emailAddress, town, country, motto1, motto2, likes, dislikes, gpsCoordinates, enneagramtype1, enneagramtype2, userModel);
     		if (!userModel.checkNameIsUnique()) {
    			return;
    		}
     		/*
     		Aspects aspects = Aspects.instanceFor(userModel);
     		Map aspectMap = (Map) Reflector.get(aspects, "aspects");
     		for (Iterator i = aspectMap.values().iterator(); i.hasNext();) {
     			AbstractAspect aspect = (AbstractAspect)i.next();
     			aspect.validate("", aspect.getValue(userModel), , errors)
     		}
     		*/
     		userModel.store();
    	} else {
    		// update user
    		Session session = SessionStore.getSession(sessionId);
    		if (session == null) {
    			return;
    		}
    		try {
    			SecurityContext securityContext = (SecurityContext) session.getAttribute(ABAXX_SECURITY_CONTEXT);
	    		if (securityContext == null) {
	    			return;
	    		}
	    		WSSecurityContext.setCurrent(securityContext);
	    		UserModel userModel = new UserModel((UserAccount) securityContext.identity());
	    		fillUserModel(password, fullname, emailAddress, town, country, motto1, motto2, likes, dislikes, gpsCoordinates, enneagramtype1, enneagramtype2, userModel);
	     		userModel.store();

	    	} catch (RuntimeException e) {
	    		Trace.error(e, this);
	    		throw e;
	    	} finally {
	
	    		SecurityContext.reset();
	    	}
    	}
    }

	private void fillUserModel(java.lang.String password, java.lang.String fullname, java.lang.String emailAddress, java.lang.String town, java.lang.String country, java.lang.String motto1, java.lang.String motto2, java.lang.String[] likes, java.lang.String[] dislikes, java.lang.String gpsCoordinates, int enneagramtype1, int enneagramtype2, UserModel userModel) {
		userModel.setPassword(password);
		int ix = fullname.indexOf(" ");
		if (ix < 0) {
			userModel.setLastname(fullname);
		} else {
			userModel.setFirstname(fullname.substring(0, ix));
			userModel.setLastname(fullname.substring(ix+1));
		}
		userModel.setEmail(emailAddress);
		userModel.setTown(town);
		userModel.setCountry(country);
		userModel.setPrimaryMotto(motto1);
		userModel.setSecondaryMotto(motto2);
		userModel.setLikes(Arrays.asList(likes));
		userModel.setDislikes(Arrays.asList(dislikes));
		userModel.setGps(gpsCoordinates);
		userModel.setPrimaryEnneagram(enneagramtype1);
		userModel.setSecondaryEnneagram(enneagramtype2);
	}

	protected List search(Long userId,boolean noContact, boolean noRcdSent, boolean newlyRegistered, int newlyRegisteredSinceDays, boolean inMyCountry, int maxKilometersAway, java.lang.String[] tttTypes, boolean myEnneagramType1, boolean myEnneagramType, boolean relatedEnneagramType, java.lang.String mottoContains, int minLikesShared, int minDislikesShared, int maxLikesDisliked, int maxDislikesLiked) {
		SearchModel model = new SearchModel();
		model.setNotMyContacts(noContact);
		model.setNotReceivedAnRcd(noRcdSent);
		if (newlyRegistered) {
			model.getRegisteredDuring().setSelection("My last logout");
		} else {
			setIfNotNull(model.getRegisteredDuring(), newlyRegisteredSinceDays);
		}
		model.setOnlyMembersInMyCountry(inMyCountry);
		setIfNotNull(model.getLiveAround(), maxKilometersAway);
		model.getTttType().setSelectionKeys(tttTypes);
		model.setSameEnneagram(myEnneagramType);
		model.setOneOfMineEnneagram(myEnneagramType1);
		model.setRelatedEnneagram(relatedEnneagramType);
		model.setLifeMotto(mottoContains);
		setIfNotNull(model.getShareMyLikes(), minLikesShared);
		setIfNotNull(model.getShareMyDislikes(), minDislikesShared);
		setIfNotNull(model.getDislikeNoneOfLikes(), maxLikesDisliked);
		setIfNotNull(model.getLikeNoneOfMyDislikes(), maxDislikesLiked);

        Member member = (Member) MemberManager.instance().getWithId(Member.class, userId);
        
        List memberList = new SearchController().search(model,member);
		return memberList;
	}


}
