package com.ats.platforms.domain;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * This class is used to represent an address1.
 * </p>
 * 
 * <p>
 * <a href="Address.java.html"><i>View Source</i></a>
 * </p>
 * 
 * @author <a href="mailto:matt@raibledesigns.com">Matt Raible</a>
 * 
 */
public class Address extends BaseEntity implements Serializable {
	private static final long serialVersionUID = 3617859655330969141L;

	protected String address1; // required

	protected String city; // required

	protected String country;  // required

	protected String postalCode;

	protected String province;

	protected User user;

	
	@Override
    public boolean equals(final Object other) {
        if (!(other instanceof Address))
            return false;
        Address castOther = (Address) other;
        return new EqualsBuilder().append(address1, castOther.address1).append(
                city, castOther.city).append(country, castOther.country)
                .append(postalCode, castOther.postalCode).append(province,
                        castOther.province).append(user, castOther.user)
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(address1).append(city).append(
                country).append(postalCode).append(province).append(user)
                .toHashCode();
    }

    /**
	 * 
	 */
	public String getAddress1() {
		return address1;
	}

	/**
	 * 
	 */
	public String getCity() {
		return city;
	}

	/**
	 * 
	 */
	public String getCountry() {
		return country;
	}

	/**
	 * 
	 */
	public String getPostalCode() {
		return postalCode;
	}

	/**
	 * 
	 */
	public String getProvince() {
		return province;
	}

	/**
	 * @return the user
	 */
	public User getUser() {
		return this.user;
	}

	

	public void setAddress1(String address) {
		this.address1 = address;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public void setPostalCode(String postalCode) {
		this.postalCode = postalCode;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	/**
	 * @param user
	 *            the user to set
	 */
	public void setUser(User user) {
		this.user = user;
	}

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("address1", address1).append(
                "city", city).append("country", country).append("postalCode",
                postalCode).append("province", province).append("user", user)
                .toString();
    }

	
}
