/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.domain;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * @author rmeder
 * Created: Dec 7, 2006
 * 
 * Simple JavaBean domain object with an id property.
 * Used as a base class for objects needing this property.
 * 
 */
//@Entity
public abstract class BaseEntity {
	
		
	//@Id @GeneratedValue
    //@Column(name = "ID")
    protected Long id = null;

    protected Long version;
    
	/**
	 * @return the id
	 */
	public Long getId() {
		return this.id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(Long id) {
		this.id = id;
	}

	/**
     * @return the version
     */
    public Long getVersion() {
        return this.version;
    }

    /**
     * @param version the version to set
     */
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof BaseEntity))
            return false;
        BaseEntity castOther = (BaseEntity) other;
        return new EqualsBuilder().append(id, castOther.id).append(version,
                castOther.version).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(id).append(version).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("id", id).append("version",
                version).toString();
    }
		
}
