/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.domain;

import java.io.Serializable;

import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;



/**
 * @author rmeder
 * Created: Jan 25, 2007
 * 
 *
 */
public class Ennagram extends BaseEntity implements Serializable {
    private static final long serialVersionUID = 1L;
    
    protected String name;
    protected String link;

    /**
     * @return the name
     */
    public String getName() {
        return this.name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String key) {
        this.name = key;
    }
    /**
     * @return the link
     */
    public String getLink() {
        return this.link;
    }
    /**
     * @param link the link to set
     */
    public void setLink(String link) {
        this.link = link;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof Ennagram))
            return false;
        Ennagram castOther = (Ennagram) other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(name,
                castOther.name).append(link, castOther.link).isEquals();
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(name)
                .append(link).toHashCode();
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this).appendSuper(super.toString()).append(
                "name", name).append("link", link).toString();
    }

}
