/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.domain;

import java.util.Date;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author rmeder
 * Created: Jan 25, 2007
 * 
 *
 */
public class RcdStatus extends BaseEntity {
    
    public static final Integer RCD_SEND = Integer.valueOf(1);
    public static final Integer RCD_RECEIVED = Integer.valueOf(2);
    public static final Integer RCD_CONTACT = Integer.valueOf(3);

    protected Integer status;
    protected Date timestamp;
    
    protected User userFrom;
    protected User userTo;
    /**
     * @return the status
     */
    public Integer getStatus() {
        return this.status;
    }
    /**
     * @param status the status to set
     */
    public void setStatus(Integer status) {
        this.status = status;
    }
    /**
     * @return the timestamp
     */
    public Date getTimestamp() {
        return this.timestamp;
    }
    /**
     * @param timestamp the timestamp to set
     */
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }
    /**
     * @return the userFrom
     */
    public User getUserFrom() {
        return this.userFrom;
    }
    /**
     * @param userFrom the userFrom to set
     */
    public void setUserFrom(User userFrom) {
        this.userFrom = userFrom;
    }
    /**
     * @return the userTo
     */
    public User getUserTo() {
        return this.userTo;
    }
    /**
     * @param userTo the userTo to set
     */
    public void setUserTo(User userTo) {
        this.userTo = userTo;
    }
    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof RcdStatus))
            return false;
        RcdStatus castOther = (RcdStatus) other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(
                status, castOther.status)
                .append(timestamp, castOther.timestamp).append(userFrom,
                        castOther.userFrom).append(userTo, castOther.userTo)
                .isEquals();
    }
    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(
                status).append(timestamp).append(userFrom).append(userTo)
                .toHashCode();
    }
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this).appendSuper(super.toString()).append(
                "status", status).append("timestamp", timestamp).append(
                "userFrom", userFrom).append("userTo", userTo).toString();
    }
    
   
    
}
