/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.domain;

import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;

/**
 * @author rmeder
 * Created: Jan 25, 2007
 * 
 *
 */
public class TttResult extends BaseEntity {
    
    
    protected String result;
    protected Boolean official = Boolean.valueOf(false);
    protected Date timestamp;
    
    protected User user;
    
    
    /**
     * @return the official
     */
    public Boolean getOfficial() {
        return this.official;
    }
    /**
     * @param official the official to set
     */
    public void setOfficial(Boolean official) {
        this.official = official;
    }
    /**
     * @return the result
     */
    public String getResult() {
        return this.result;
    }
    /**
     * @param result the result to set
     */
    public void setResult(String result) {
        this.result = result;
    }
    
    /**
     * @return the timestamp
     */
    public Date getTimestamp() {
        return this.timestamp;
    }
    /**
     * @param timestamp the timestamp to set
     */
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }
    /**
     * @return the user
     */
    public User getUser() {
        return this.user;
    }
    /**
     * @param user the user to set
     */
    public void setUser(User user) {
        this.user = user;
    }
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this).appendSuper(super.toString()).append(
                "result", result).append("official", official).append(
                "timestamp", timestamp).append("user", user).toString();
    }
    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof TttResult))
            return false;
        TttResult castOther = (TttResult) other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(
                result, castOther.result).append(official, castOther.official)
                .append(timestamp, castOther.timestamp).append(user,
                        castOther.user).isEquals();
    }
    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(
                result).append(official).append(timestamp).append(user)
                .toHashCode();
    }


}
