package com.ats.platforms.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * User business domain object
 * 
 * <p>
 * <a href="User.java.html"><i>View Source</i></a>
 * 
 * @author <a href="mailto:robert.mederer@accenture.com">Robert Mederer</a>
 * 
 */
public class User extends BaseEntity implements Serializable, UserDetails {
	private static final long serialVersionUID = 3832626162173359411L;

	protected String username; // required

	protected String password; // required

	protected String confirmPassword;

	protected String passwordHint;

	protected String firstName; // required

	protected String lastName; // required

	protected String email; // required; unique

	protected String lifeMotto; // required

	protected String lifeMotto2; // optional

	protected Address address = new Address(); // required

	
    
    private String likes;   // optional
    private String dislikes;    // optional
    private String gpsCoordinates;  // optional
    
    private Ennagram primaryEnnagram;  // optional
    private Ennagram secondaryEnnagram;    // optional
    
    private Date registrationDate; // optional
    private Date lastLoginDate; // optional
    private Date lastLogOffDate; // optional
    
//    protected List<TttResult> tttResults = new ArrayList<TttResult>(); 
    

	protected Set<Role> roles = new HashSet<Role>();

	protected boolean enabled;

	protected boolean accountExpired;

	protected boolean accountLocked;

	protected boolean credentialsExpired;

	public User() {
	}

	public User(String username) {
		this.username = username;
	}

	/**
	 * 
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * 
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * 
	 */
	public String getConfirmPassword() {
		return confirmPassword;
	}

	/**
	 * 
	 */
	public String getPasswordHint() {
		return passwordHint;
	}

	/**
	 * 
	 */
	public String getFirstName() {
		return firstName;
	}

	/**
	 * 
	 */
	public String getLastName() {
		return lastName;
	}

	/**
	 * 
	 */
	public String getEmail() {
		return email;
	}

	/**
	 * 
	 */
	public String getLifeMotto() {
		return lifeMotto;
	}

	/**
	 * 
	 */
	public String getLifeMotto2() {
		return lifeMotto2;
	}

	/**
	 * Returns the full name.
	 */
	public String getFullName() {
		return firstName + ' ' + lastName;
	}

	/**
	 * @hibernate.component
	 */
	public Address getAddress() {
		return address;
	}

	/**
	 * 
	 */
	public Set<Role> getRoles() {
		return roles;
	}

	/**
	 * Adds a role for the user
	 * 
	 * @param role
	 */
	public void addRole(Role role) {
		getRoles().add(role);
	}

	/**
	 * @see org.acegisecurity.userdetails.UserDetails#getAuthorities()
	 */
	public GrantedAuthority[] getAuthorities() {
		return (GrantedAuthority[]) roles.toArray(new GrantedAuthority[0]);
	}


	/**
	 * 
	 */
	public boolean isEnabled() {
		return enabled;
	}

	/**
	 * 
	 */
	public boolean isAccountExpired() {
		return accountExpired;
	}

	/**
	 * @see org.acegisecurity.userdetails.UserDetails#isAccountNonExpired()
	 */
	public boolean isAccountNonExpired() {
		return !isAccountExpired();
	}

	/**
	 * 
	 */
	public boolean isAccountLocked() {
		return accountLocked;
	}

	/**
	 * @see org.acegisecurity.userdetails.UserDetails#isAccountNonLocked()
	 */
	public boolean isAccountNonLocked() {
		return !isAccountLocked();
	}

	/**
	 * 
	 */
	public boolean isCredentialsExpired() {
		return credentialsExpired;
	}

	/**
	 * @see org.acegisecurity.userdetails.UserDetails#isCredentialsNonExpired()
	 */
	public boolean isCredentialsNonExpired() {
		return !credentialsExpired;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public void setConfirmPassword(String confirmPassword) {
		this.confirmPassword = confirmPassword;
	}

	public void setPasswordHint(String passwordHint) {
		this.passwordHint = passwordHint;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public void setLifeMotto(String phoneNumber) {
		this.lifeMotto = phoneNumber;
	}

	public void setLifeMotto2(String website) {
		this.lifeMotto2 = website;
	}

	public void setAddress(Address address) {
		this.address = address;
	}

	public void setRoles(Set<Role> roles) {
		this.roles = roles;
	}

	

	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}

	public void setAccountExpired(boolean accountExpired) {
		this.accountExpired = accountExpired;
	}

	public void setAccountLocked(boolean accountLocked) {
		this.accountLocked = accountLocked;
	}

	public void setCredentialsExpired(boolean credentialsExpired) {
		this.credentialsExpired = credentialsExpired;
	}

    /**
     * @return the lastLoginDate
     */
    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    /**
     * @param lastLoginDate the lastLoginDate to set
     */
    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    /**
     * @return the lastLogOffDate
     */
    public Date getLastLogOffDate() {
        return this.lastLogOffDate;
    }

    /**
     * @param lastLogOffDate the lastLogOffDate to set
     */
    public void setLastLogOffDate(Date lastLogOffDate) {
        this.lastLogOffDate = lastLogOffDate;
    }

    /**
     * @return the registrationDate
     */
    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    /**
     * @param registrationDate the registrationDate to set
     */
    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    /**
     * @return the dislikes
     */
    public String getDislikes() {
        return this.dislikes;
    }

    /**
     * @param dislikes the dislikes to set
     */
    public void setDislikes(String dislikes) {
        this.dislikes = dislikes;
    }

    /**
     * @return the gpsCoordinates
     */
    public String getGpsCoordinates() {
        return this.gpsCoordinates;
    }

    /**
     * @param gpsCoordinates the gpsCoordinates to set
     */
    public void setGpsCoordinates(String gpsCoordinates) {
        this.gpsCoordinates = gpsCoordinates;
    }

    /**
     * @return the likes
     */
    public String getLikes() {
        return this.likes;
    }

    /**
     * @param likes the likes to set
     */
    public void setLikes(String likes) {
        this.likes = likes;
    }

    

//    /**
//     * @return the tttResults
//     */
//    public List<TttResult> getTttResults() {
//        return this.tttResults;
//    }

//    /**
//     * @param tttResults the tttResults to set
//     */
//    public void setTttResults(List<TttResult> tttResults) {
//        this.tttResults = tttResults;
//    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof User))
            return false;
        User castOther = (User) other;
        return new EqualsBuilder().append(username, castOther.username).append(
                password, castOther.password).append(confirmPassword,
                castOther.confirmPassword).append(passwordHint,
                castOther.passwordHint).append(firstName, castOther.firstName)
                .append(lastName, castOther.lastName).append(email,
                        castOther.email).append(lifeMotto, castOther.lifeMotto)
                .append(lifeMotto2, castOther.lifeMotto2).append(address,
                        castOther.address).append(likes, castOther.likes)
                .append(dislikes, castOther.dislikes).append(gpsCoordinates,
                        castOther.gpsCoordinates).append(primaryEnnagram,
                        castOther.primaryEnnagram).append(
                        secondaryEnnagram, castOther.secondaryEnnagram)
                .append(registrationDate, castOther.registrationDate).append(
                        lastLoginDate, castOther.lastLoginDate).append(
                        lastLogOffDate, castOther.lastLogOffDate).append(roles,
                        castOther.roles).append(enabled, castOther.enabled)
                .append(accountExpired, castOther.accountExpired).append(
                        accountLocked, castOther.accountLocked).append(
                        credentialsExpired, castOther.credentialsExpired)
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(username).append(password).append(
                confirmPassword).append(passwordHint).append(firstName).append(
                lastName).append(email).append(lifeMotto).append(lifeMotto2)
                .append(address).append(likes).append(dislikes).append(
                        gpsCoordinates).append(primaryEnnagram).append(
                        secondaryEnnagram).append(registrationDate).append(
                        lastLoginDate).append(lastLogOffDate).append(roles)
                .append(enabled).append(accountExpired).append(accountLocked)
                .append(credentialsExpired).toHashCode();
    }

    /**
     * @param primaryEnnagram the primaryEnnagram to set
     */
    public void setPrimaryEnnagram(Ennagram primaryEnnagram) {
        this.primaryEnnagram = primaryEnnagram;
    }

    /**
     * @param secondaryEnnagram the secondaryEnnagram to set
     */
    public void setSecondaryEnnagram(Ennagram secondaryEnnagram) {
        this.secondaryEnnagram = secondaryEnnagram;
    }

    /**
     * @return the primaryEnnagram
     */
    public Ennagram getPrimaryEnnagram() {
        return this.primaryEnnagram;
    }

    /**
     * @return the secondaryEnnagram
     */
    public Ennagram getSecondaryEnnagram() {
        return this.secondaryEnnagram;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this).appendSuper(super.toString()).append(
                "username", username).append("password", password).append(
                "confirmPassword", confirmPassword).append("passwordHint",
                passwordHint).append("firstName", firstName).append("lastName",
                lastName).append("email", email).append("lifeMotto", lifeMotto)
                .append("lifeMotto2", lifeMotto2).append("address", address)
                .append("likes", likes).append("dislikes", dislikes).append(
                        "gpsCoordinates", gpsCoordinates).append(
                        "primaryEnnagram", primaryEnnagram).append(
                        "secondaryEnnagram", secondaryEnnagram).append(
                        "registrationDate", registrationDate).append(
                        "lastLoginDate", lastLoginDate).append(
                        "lastLogOffDate", lastLogOffDate)
                .append("roles", roles).append("enabled", enabled).append(
                        "accountExpired", accountExpired).append(
                        "accountLocked", accountLocked).append(
                        "credentialsExpired", credentialsExpired).toString();
    }

}
