/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.ttt.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ats.platforms.ttt.service.TrivialTemperamentService;

/**
 * @author jens.eickmeyer
 * Created: 25.01.2007
 * 
 *
 */
public class TrivialTemperamentServiceImpl implements TrivialTemperamentService {

    /* (non-Javadoc)
     * @see com.ats.platforms.ttt.service.TrivialTemperamentService#calculateTemperament(java.util.List)
     */
    public String calculateTemperament(List<String> answers) {
        Map<String, Integer> dimensions = new HashMap<String, Integer>();
        dimensions.put("E", 0);
        dimensions.put("I", 0);
        dimensions.put("S", 0);
        dimensions.put("N", 0);
        dimensions.put("T", 0);
        dimensions.put("F", 0);
        dimensions.put("J", 0);
        dimensions.put("P", 0);
        
        // How often was each of the types selected
        for(String answer : answers) {
            if(!answer.trim().equals("")) {
                int num = dimensions.get(answer);
                dimensions.put(answer, ++num);
            }
        }
        
        int ei = dimensions.get("E") - dimensions.get("I");
        int sn = dimensions.get("S") - dimensions.get("N");
        int tf = dimensions.get("T") - dimensions.get("F");
        int jp = dimensions.get("J") - dimensions.get("P");
        
        StringBuffer result = new StringBuffer();
        
        result.append(computeTendency(ei, "E", "I"));
        result.append(computeTendency(sn, "S", "N"));
        result.append(computeTendency(tf, "T", "F"));
        result.append(computeTendency(jp, "J", "P"));
        
        Log logger = LogFactory.getLog(getClass());
        logger.error(result.toString());
        
        return result.toString();
    }
    
    private String computeTendency(int difference, String firstDimension, String secondDimension) {
        StringBuffer result = new StringBuffer();
        
        if(difference < 0) {
            result.append(secondDimension).append("+").append(difference * -1);
        } else if(difference == 0) {
            result.append(firstDimension).append("+0");
        } else {
            result.append(firstDimension).append("+").append(difference);
        }
        
        return result.toString();
    }

}
