package com.ats.platforms.dao;

import java.io.Serializable;
import java.util.List;

import com.ats.platforms.domain.Role;


/**
 * Data Access Object (Dao) interface.   This is an interface
 * used to tag our Dao classes and to provide common methods to all Daos.
 *
 * <p><a href="Dao.java.html"><i>View Source</i></a></p>
 *
 * @author <a href="mailto:robert.mederer@accenture.com">Robert Mederer</a>
 */
public interface Dao<T, ID extends Serializable> {

    /**
     * Generic method used to get all objects of a particular type. This
     * is the same as lookup up all rows in a table.
     * @param clazz the type of objects (a.k.a. while table) to get data from
     * @return List of populated objects
     */
    //public List getObjects(Class clazz);
    
    /**
     * Generic method to get an object based on class and identifier. An 
     * ObjectRetrievalFailureException Runtime Exception is thrown if 
     * nothing is found.
     * 
     * @param clazz model class to lookup
     * @param id the identifier (primary name) of the class
     * @return a populated object
     * @see org.springframework.orm.ObjectRetrievalFailureException
     */
    //public Object getObject(Class clazz, Serializable id);

    /**
     * returns all entities 
     * 
     * @return all entities
     */
    List<T> find();

    /**
     * Finds users information based on user id.
     * 
     * @param id the id of the user to find
     * @return the user instance for the id or null
     */
    T find(ID id);
    
    /**
     * Finds all objects with matches to the given object properties.
     *
     * @return List populated list of objects
     */
    public List find(T o);
    
    /**
     * Generic method to save an object - handles both update and insert.
     * @param o the object to save
     */
    void persist(T o);
    
    /**
     * @param entity
     */
    void remove(T entity);
    
    /**
     * Generic method to delete an object based on class and id
     * @param clazz model class to lookup
     * @param id the identifier (primary name) of the class
     */
    void remove(Class<? extends Role> clazz, ID id);
}