/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
package com.ats.platforms.dao;

import java.io.Serializable;

/**
 * Generic DAO operations interface
 * 
 * @author <a href="mailto:robert.mederer@accenture.com">Robert Mederer</a>
 * Created: Dec 7, 2006
 * 
 *
 */
public interface GenericJpaDao<T, ID extends Serializable> extends Dao<T, ID> {

    /**
     * 
     */
    void clear();

    /**
     * @param entity
     * @return
     */
    boolean contains(Object entity);

    /**
     * 
     */
    void flush();
    
    /**
     * @param entity
     * @return
     */
    T merge(T entity);
    
    
    /**
     * @param entity
     */
    public void refresh(Object entity);

}
