package com.ats.platforms.dao;

import java.util.List;

import com.ats.platforms.domain.Ennagram;
import com.ats.platforms.domain.Role;


/**
 * Lookup Data Access Object (Dao) interface.  This is used to lookup values in
 * the database (i.e. for drop-downs).
 *
 * <p>
 * <a href="LookupDao.java.html"><i>View Source</i></a>
 * </p>
 *
 * @author <a href="mailto:robert.mederer@accenture.com">Robert Mederer</a>
 */
public interface LookupDao {
    
    /**
     * @return list of roles
     */
    public List<Role> getRoles();

    /**
     * @return list of ennagrams
     */
    public List<Ennagram> getEnnagrams();
}
